package ru.yandex.direct.web.entity.offerretargeting.presentation

import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Gen.OFFER_RETARGETING_ALREADY_DELETED
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Gen.OFFER_RETARGETING_ALREADY_SUSPENDED
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Gen.OFFER_RETARGETING_CANT_BE_USED_IN_AUTO_BUDGET_CAMPAIGN
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Gen.OFFER_RETARGETING_NOT_SUSPENDED
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Number.TOO_MANY_OFFER_RETARGETINGS_IN_AD_GROUP
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect
import ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect

object OfferRetargetingDefectPresentations {

    @JvmStatic
    fun offerRetargetingDefectPresentationRegistry(): DefaultDefectPresentationRegistry<TranslatableWebDefect> {
        return DefaultDefectPresentationRegistry.builder()
            .register(OFFER_RETARGETING_CANT_BE_USED_IN_AUTO_BUDGET_CAMPAIGN, defaultWebDefect())
            .register(OFFER_RETARGETING_ALREADY_DELETED, defaultWebDefect())
            .register(OFFER_RETARGETING_ALREADY_SUSPENDED, defaultWebDefect())
            .register(OFFER_RETARGETING_NOT_SUSPENDED, defaultWebDefect())
            .register(TOO_MANY_OFFER_RETARGETINGS_IN_AD_GROUP, defaultWebDefect())
            .build()
    }
}
