package ru.yandex.direct.web.entity.offlinereport.controller;

import javax.servlet.http.HttpServletResponse;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import ru.yandex.direct.common.util.HttpUtil;
import ru.yandex.direct.core.entity.offlinereport.model.OfflineReport;
import ru.yandex.direct.core.entity.offlinereport.service.OfflineReportService;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.web.annotations.AllowedOperatorRoles;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;

@Controller
@RequestMapping(value = "/offline_report")
@Api(tags = "offline_report")
@AllowedOperatorRoles({RbacRole.SUPER, RbacRole.SUPERREADER, RbacRole.SUPPORT, RbacRole.MANAGER, RbacRole.AGENCY})
@AllowedSubjectRoles({RbacRole.SUPER, RbacRole.SUPERREADER, RbacRole.SUPPORT, RbacRole.MANAGER, RbacRole.AGENCY})
public class OfflineReportController {
    private final OfflineReportService offlineReportService;
    private final DirectWebAuthenticationSource authSource;

    public OfflineReportController(OfflineReportService offlineReportService,
                                   DirectWebAuthenticationSource authSource) {
        this.offlineReportService = offlineReportService;
        this.authSource = authSource;
    }

    @ApiOperation(value = "Скачать отчет. Возвращает внутренний редирект на скачивание", httpMethod = "GET")
    @RequestMapping(path = "/download", method = RequestMethod.GET)
    public void downloadReport(@RequestParam("report_id") Long reportId, HttpServletResponse response,
                               @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN) String subjectLogin) {
        DirectAuthentication auth = authSource.getAuthentication();
        ClientId clientId = auth.getOperator().getClientId();

        OfflineReport report = offlineReportService.getReport(reportId, clientId);
        if (report == null || report.getReportUrl() == null) {
            response.setStatus(HttpServletResponse.SC_NOT_FOUND);
            return;
        }

        HttpUtil.setInternalRedirectToMdsDirectFiles(response, report.getReportUrl(), null);
    }
}
