package ru.yandex.direct.web.entity.payment.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.web.entity.payment.util.PaymentUtils.CARD_ID_FIELD;
import static ru.yandex.direct.web.entity.payment.util.PaymentUtils.IS_LEGAL_PERSON_FIELD;
import static ru.yandex.direct.web.entity.payment.util.PaymentUtils.PAYMENT_SUM_FIELD;
import static ru.yandex.direct.web.entity.payment.util.PaymentUtils.REMAINING_SUM_FIELD;

public class PaymentFormRequest {

    @JsonProperty(value = "sum", required = true)
    private BigDecimal sum;

    @JsonProperty(value = IS_LEGAL_PERSON_FIELD, required = true)
    private Boolean isLegalPerson;

    @JsonProperty(CARD_ID_FIELD)
    private String cardId;

    @JsonProperty(REMAINING_SUM_FIELD)
    private BigDecimal remainingSum;

    @JsonProperty(PAYMENT_SUM_FIELD)
    private BigDecimal paymentSum;

    @JsonProperty(value = "promocode")
    private String promocode;

    @JsonProperty(value = "is_mobile")
    private boolean isMobile = false;

    public BigDecimal getSum() {
        return sum;
    }

    public Boolean getIsLegalPerson() {
        return isLegalPerson;
    }

    public String getCardId() {
        return cardId;
    }

    public BigDecimal getRemainingSum() {
        return remainingSum;
    }

    public BigDecimal getPaymentSum() {
        return paymentSum;
    }

    public String getPromocode() {
        return promocode;
    }

    public void setPromocode(String promocode) {
        this.promocode = promocode;
    }

    public boolean getIsMobile() {
        return isMobile;
    }
}
