package ru.yandex.direct.web.entity.payment.model;

import java.math.BigDecimal;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.validation.model.WebValidationResult;

public class PaymentFormResponse {

    @JsonProperty("paymentUrl")
    private final String paymentUrl;
    @JsonProperty("bindingUrl")
    private final String bindingUrl;
    @JsonProperty("validationResult")
    private final WebValidationResult validationResult;
    @JsonProperty("amount")
    private final BigDecimal amount;
    @Deprecated
    @JsonProperty("formVersion")
    // для использования новой формы траста TODO удалить после https://st.yandex-team.ru/DIRECT-158740
    private final Integer formVersion = 2;

    public PaymentFormResponse(String paymentUrl, @Nullable String bindingUrl,
                               @Nullable WebValidationResult validationResult,
                               BigDecimal amount) {
        this.paymentUrl = paymentUrl;
        this.bindingUrl = bindingUrl;
        this.validationResult = validationResult;
        this.amount = amount;
    }
}
