package ru.yandex.direct.web.entity.payment.util;

import java.net.URISyntaxException;

import org.apache.http.client.utils.URIBuilder;

import ru.yandex.direct.common.util.HostUtils;

import static org.eclipse.jetty.util.URIUtil.HTTPS;

public class PaymentUtils {

    private PaymentUtils() {
    }

    public static final String CARD_ID_FIELD = "card_id";
    public static final String PAYMENT_SUM_FIELD = "autopayment_sum";
    public static final String REMAINING_SUM_FIELD = "remaining_sum";
    public static final String IS_LEGAL_PERSON_FIELD = "is_ur";
    public static final String PAYMENT_PATH = "/payment";

    private static final String PERL_BASE_URI = "/registered/main.pl";

    public static String getSuccessRedirectUri() {

        String host = HostUtils.getRemoteHost().orElseThrow();

        try {
            return new URIBuilder()
                    .setScheme(HTTPS)
                    .setHost(host)
                    .setPath(PERL_BASE_URI)
                    .setParameter("cmd", "paymentSuccess")
                    .build()
                    .toString();
        } catch (URISyntaxException e) {
            throw new IllegalStateException("got exception while creating url", e);
        }
    }
}
