package ru.yandex.direct.web.entity.pricepackage.presentation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.pricepackage.service.validation.defects.PricePackageDefectIds;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;

@ParametersAreNonnullByDefault
public class PricePackageDefectPresentations {

    private PricePackageDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect>
    pricePackagesDefectPresentationRegistry() {
        CommonDefectTranslations translations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(PricePackageDefectIds.Gen.CLIENT_CURRENCY_NOT_EQUALS_PACKAGE_CURRENCY, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.GEO_EXPANDED_IS_EMPTY, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.PRICE_PACKAGE_IS_EXPIRED, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.CRYPTA_TYPES_COUNT_IS_MISMATCHED, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_IS_EMPTY, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_AND_AD_GROUP_TYPES_MISMATCHED,
                        defaultWebDefect())
                .register(PricePackageDefectIds.Gen.MUTUAL_EXCLUSIVE_BID_MODIFIERS_SELECTED, defaultWebDefect())
                .register(PricePackageDefectIds.DateTime.USER_TIMESTAMP_NOT_EQUALS_LAST_UPDATE_TIME,
                        paramWebDefect(di -> translations.pricePackageTimestampNotEqualsUserTimestamp(
                                di.getDefect().params().getExpectedValue().toString())))
                .register(PricePackageDefectIds.Gen.DATE_START_CAN_ONLY_EXPAND, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.DATE_END_CAN_ONLY_EXPAND, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_CAN_ONLY_EXPAND, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.RETARGETING_CATEGORIES_AMOUNT_LESS_LOWER_LIMIT, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.RETARGETING_CATEGORIES_AMOUNT_GREATER_UPPER_LIMIT, defaultWebDefect())
                .register(PricePackageDefectIds.Gen.OVERLAPPING_PRICE_MARKUPS, defaultWebDefect())
                .build();
    }

}
