package ru.yandex.direct.web.entity.region.presentation;

import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.DummyTranslatable;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Gen.EMPTY_REGIONS;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Gen.INCORRECT_USE_OF_ZERO_REGION;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Gen.NO_PLUS_REGIONS;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.RegionIds.INCORRECT_REGIONS;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.RegionIds.MINUS_REGION_MATCHES_PLUS_REGION;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.GEO_FRONTPAGE_BROWSER_NEW_TAB_IGNORED_REGIONS_DUE_TO_PRICE;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.GEO_FRONTPAGE_DESKTOP_IGNORED_REGIONS_DUE_TO_PRICE;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.GEO_FRONTPAGE_MOBILE_IGNORED_REGIONS_DUE_TO_PRICE;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.MINUS_REGIONS_WITHOUT_PLUS_REGIONS;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.NON_UNIQUE_REGIONS;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class RegionDefectPresentations {

    private RegionDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> regionDefectPresentationRegistry() {
        CommonDefectTranslations translations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(EMPTY_REGIONS,
                        webDefect(translations.badGeoDetailedEmptyRegions()))
                .register(INCORRECT_USE_OF_ZERO_REGION,
                        webDefect(translations.badGeoDetailedIncorrectUseOfZeroRegion()))
                .register(NO_PLUS_REGIONS,
                        webDefect(translations.badGeoDetailedNoPlusRegions()))
                .register(INCORRECT_REGIONS,
                        paramWebDefect(di -> translations.badGeoDetailedIncorrectRegions(
                                di.getDefect().params().getRegionIds())))
                .register(MINUS_REGION_MATCHES_PLUS_REGION,
                        paramWebDefect(di -> translations.badGeoDetailedMinusRegionMatchesPlusRegion(
                                di.getDefect().params().getMinusRegionIds(),
                                di.getDefect().params().getRegionIds())))
                .register(MINUS_REGIONS_WITHOUT_PLUS_REGIONS,
                        paramWebDefect(di -> translations.badGeoDetailedMinusRegionsWithoutPlusRegions(
                                new DummyTranslatable(
                                        di.getDefect().params().toIdsString()))))
                .register(NON_UNIQUE_REGIONS,
                        paramWebDefect(di -> translations.badGeoDetailedNonUniqueRegions(
                                new DummyTranslatable(
                                        di.getDefect().params().toIdsString()))))
                .register(GEO_FRONTPAGE_DESKTOP_IGNORED_REGIONS_DUE_TO_PRICE,
                        paramWebDefect(di -> translations.regionsIgnoredDesktopBecauseOfPrice(
                                new DummyTranslatable(di.getDefect().params().toIdsString()))))
                .register(GEO_FRONTPAGE_MOBILE_IGNORED_REGIONS_DUE_TO_PRICE,
                        paramWebDefect(di -> translations.regionsIgnoredMobileBecauseOfPrice(
                                new DummyTranslatable(di.getDefect().params().toIdsString()))))
                .register(GEO_FRONTPAGE_BROWSER_NEW_TAB_IGNORED_REGIONS_DUE_TO_PRICE,
                        paramWebDefect(di -> translations.regionsIgnoredBrowserNewTabBecauseOfPrice(
                                new DummyTranslatable(di.getDefect().params().toIdsString()))))
                .build();
    }
}
