package ru.yandex.direct.web.entity.relevancematch.converter;

import java.math.BigDecimal;
import java.util.List;

import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.utils.FunctionalUtils;
import ru.yandex.direct.web.entity.relevancematch.model.WebRelevanceMatch;

import static org.apache.commons.lang3.BooleanUtils.isTrue;

public class RelevanceMatchConverter {

    public static List<RelevanceMatch> webRelevanceMatchesToCore(List<WebRelevanceMatch> webRelevanceMatches) {
        return FunctionalUtils.mapList(webRelevanceMatches, RelevanceMatchConverter::webRelevanceMatchToCore);
    }

    public static RelevanceMatch webRelevanceMatchToCore(WebRelevanceMatch webRelevanceMatch) {
        if (webRelevanceMatch == null) {
            return null;
        }

        Long id = webRelevanceMatch.getId() != null && !webRelevanceMatch.getId().equals(0L) ?
                webRelevanceMatch.getId() : null;
        BigDecimal price = webRelevanceMatch.getPrice() != null && webRelevanceMatch.getPrice() != 0 ?
                BigDecimal.valueOf(webRelevanceMatch.getPrice()) : null;
        Integer autobudgetPriority = webRelevanceMatch.getAutoBudgetPriority() != null &&
                webRelevanceMatch.getAutoBudgetPriority() != 0 ?
                webRelevanceMatch.getAutoBudgetPriority() : null;
        return new RelevanceMatch()
                .withId(id)
                .withPrice(price)
                .withAutobudgetPriority(autobudgetPriority)
                .withIsSuspended(isTrue((webRelevanceMatch.getSuspended())));
    }
}
