package ru.yandex.direct.web.entity.relevancematch.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebRelevanceMatch {

    public static class Prop {
        private Prop() {
        }

        public static final String ID = "bid_id";
        public static final String PRICE = "price";
        public static final String PRICE_CONTEXT = "price_context";
        public static final String AUTOBUDGET_PRIORITY = "autobudgetPriority";
        public static final String IS_SUSPENDED = "is_suspended";
    }

    @JsonProperty(Prop.ID)
    private Long id;

    @JsonProperty(Prop.PRICE)
    private Double price;

    @JsonProperty(Prop.PRICE_CONTEXT)
    private Double priceContext;

    @JsonProperty(Prop.AUTOBUDGET_PRIORITY)
    private Integer autoBudgetPriority;

    @JsonProperty(Prop.IS_SUSPENDED)
    private Boolean isSuspended;

    public Long getId() {
        return id;
    }

    public WebRelevanceMatch withId(Long id) {
        this.id = id;
        return this;
    }

    public Double getPrice() {
        return price;
    }

    public WebRelevanceMatch withPrice(Double price) {
        this.price = price;
        return this;
    }

    public Double getPriceContext() {
        return priceContext;
    }

    public WebRelevanceMatch withPriceContext(Double priceContext) {
        this.priceContext = priceContext;
        return this;
    }

    public Integer getAutoBudgetPriority() {
        return autoBudgetPriority;
    }

    public WebRelevanceMatch withAutoBudgetPriority(Integer autoBudgetPriority) {
        this.autoBudgetPriority = autoBudgetPriority;
        return this;
    }

    public Boolean getSuspended() {
        return isSuspended;
    }

    public WebRelevanceMatch withSuspended(Boolean suspended) {
        isSuspended = suspended;
        return this;
    }
}
