package ru.yandex.direct.web.entity.relevancematch.presentation;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_ALREADY_DELETED;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_ALREADY_SUSPENDED;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_DELETED_FROM_ADGROUP_WITHOUT_PHRASES;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_USED_IN_AUTO_BUDGET_COMPANY;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_USED_WHEN_SEARCH_IS_STOPPED;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_NOT_SUSPENDED;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Number.TOO_MANY_RELEVANCE_MATCH_IN_AD_GROUP;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;

public class RelevanceMatchDefectPresentations {

    private RelevanceMatchDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> relevanceMatchDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(RELEVANCE_MATCH_CANT_BE_USED_IN_AUTO_BUDGET_COMPANY,
                        defaultWebDefect())
                .register(RELEVANCE_MATCH_CANT_BE_USED_WHEN_SEARCH_IS_STOPPED,
                        defaultWebDefect())
                .register(RELEVANCE_MATCH_ALREADY_DELETED,
                        defaultWebDefect())
                .register(RELEVANCE_MATCH_CANT_BE_DELETED_FROM_ADGROUP_WITHOUT_PHRASES,
                        defaultWebDefect())
                .register(TOO_MANY_RELEVANCE_MATCH_IN_AD_GROUP,
                        defaultWebDefect())
                .register(RELEVANCE_MATCH_ALREADY_SUSPENDED,
                        defaultWebDefect())
                .register(RELEVANCE_MATCH_NOT_SUSPENDED,
                        defaultWebDefect())
                .build();
    }
}
