package ru.yandex.direct.web.entity.retargeting.presentation;

import ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.retargeting.Constants.MAX_INTEREST_RULES_PER_CONDITION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.FieldRequirements.LEAST_ONE_FIELD_REQUIRED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.FieldRequirements.MUTUALLY_EXCLUSIVE_PARAMETERS;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.ABSENT_IDS_IN_SELECTION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.ALL_CRYPTA_GOALS_MUST_HAVE_SAME_TYPE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.ALL_GOALS_MUST_BE_EITHER_FROM_METRIKA_OR_CRYPTA;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.ALL_SOCIAL_DEMO_GOALS_MUST_HAVE_SAME_PARENT_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.AUDIENCE_NOT_FOUND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.AUDIENCE_TARGET_ALLOWED_IN_MOBILE_CONTENT_CAMPAIGN;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.CANNOT_CHANGE_RETARGETING_SCOPE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.CPM_YNDX_FRONTPAGE_RETARGETINGS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.CRYPTA_GOALS_ALLOWED_ONLY_FOR_INTERESTS_TYPE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.CRYPTA_GOALS_ALLOWED_ONLY_FOR_OR_CONDITION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_GOAL;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_OBJECT_WITH_NAME;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_OBJECT_WITH_RULES;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_CONDITION_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_CONDITION_ID_FOR_ADGROUP_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INCONSISTENT_RETARGETING_CONDITION_BY_DEFAULT_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INCONSISTENT_STATE_TARGETING_CATEGORY;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INTERESTS_TYPE_IS_NOT_SPECIFIED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INTEREST_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_GOALS_FOR_TYPE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION_BY_PRICE_PACKAGE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION_IN_USER_PROFILE_FOR_TGO;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_USE_OF_FIELD_EXTRA_FIELD_FOR_GOAL_OR_SEGMENT;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.LIMIT_MUST_BE_GREATER_THAN_ZERO;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.MAX_IDS_IN_SELECTION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.MUST_CONTAIN_POSITIVE_ELEMENT;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.MUST_NOT_CONTAIN_ALL_ELEMENTS;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.NOT_ELIGABLE_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.NOT_FOUND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.NO_NEEDED_PARAMS_IN_SELECTION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.NO_RIGHTS_IN_ARCHIVED_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.OFFSET_MUST_BE_POSITIVE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.REQUIRED_TIME_FOR_GOAL_OR_SEGMENT;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.RETARGETING_CONDITION_ALREADY_EXISTS;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.RETARGETING_CONDITION_NOT_FOUND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.UNSUPPORTED_GOAL_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.WARNING_ALREADY_SUSPENDED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.WARNING_DUPLICATED_RETARGETING_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.WARNING_NOT_SUSPENDED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.ADGROUP_NOT_FOUND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_ADD;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_DELETE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_RESUME;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_SUSPEND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.RETARGETING_CONDITION_NOT_FOUND_WITH_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Nums.LIMIT_MUST_BE_LESS_THAN_VALUE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Nums.MAX_SIZE_IN_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Nums.MAX_SIZE_IN_CPM_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Nums.MAX_SIZE_USER_PROFILE_IN_CPM_ADGROUP;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class RetargetingDefectPresentations {

    private RetargetingDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> retargetingDefectPresentationRegistry() {
        CommonDefectTranslations translations = CommonDefectTranslations.INSTANCE;
        RetargetingDefectTranslations retTranslations = RetargetingDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(MAX_IDS_IN_SELECTION, defaultWebDefect())
                .register(LIMIT_MUST_BE_LESS_THAN_VALUE, defaultWebDefect())
                .register(LIMIT_MUST_BE_GREATER_THAN_ZERO, defaultWebDefect())
                .register(OFFSET_MUST_BE_POSITIVE, defaultWebDefect())
                .register(NO_NEEDED_PARAMS_IN_SELECTION, defaultWebDefect())
                .register(REQUIRED_TIME_FOR_GOAL_OR_SEGMENT, defaultWebDefect())
                .register(INVALID_USE_OF_FIELD_EXTRA_FIELD_FOR_GOAL_OR_SEGMENT, defaultWebDefect())
                .register(INVALID_GOALS_FOR_TYPE,
                        webDefect(translations.invalidGoalsForTypeNoneDetailed()))
                .register(CANNOT_CHANGE_RETARGETING_SCOPE,
                        webDefect(translations.errorRetargetingScopeChange()))
                .register(ABSENT_IDS_IN_SELECTION, defaultWebDefect())
                .register(DUPLICATED_RETARGETING_CONDITION_ID,
                        webDefect(translations.duplicatedRetargetingConditionId()))
                .register(DUPLICATED_OBJECT_WITH_NAME,
                        webDefect(translations.duplicatedObjectNameDetailed()))
                .register(AUDIENCE_NOT_FOUND,
                        webDefect(translations.audienceTargetNotFound()))
                .register(DUPLICATED_RETARGETING_ID,
                        webDefect(translations.duplicatedRetargetingId()))
                .register(NOT_FOUND,
                        webDefect(translations.notFoundRetargetingDetailed()))

                .register(ALL_GOALS_MUST_BE_EITHER_FROM_METRIKA_OR_CRYPTA,
                        webDefect(translations.allGoalsAreEitherFromMetrikaOrCrypta()))
                .register(CRYPTA_GOALS_ALLOWED_ONLY_FOR_INTERESTS_TYPE,
                        webDefect(translations.cryptaGoalsAllowedOnlyForInterestsType()))
                .register(CRYPTA_GOALS_ALLOWED_ONLY_FOR_OR_CONDITION,
                        webDefect(translations.cryptaGoalsAllowedOnlyForOrCondition()))
                .register(INTERESTS_TYPE_IS_NOT_SPECIFIED,
                        webDefect(translations.interestsTypeIsNotSpecified()))
                .register(ALL_CRYPTA_GOALS_MUST_HAVE_SAME_TYPE,
                        webDefect(translations.allCryptaGoalsMustHaveSameType()))
                .register(ALL_SOCIAL_DEMO_GOALS_MUST_HAVE_SAME_PARENT_ID,
                        webDefect(translations.allSocialDemoGoalsMustHaveSameParentId()))
                .register(MUST_NOT_CONTAIN_ALL_ELEMENTS,
                        webDefect(translations.mustNotContainAllElements()))
                .register(UNSUPPORTED_GOAL_ID,
                        webDefect(retTranslations.unsupportedGoalId()))
                .register(MUST_CONTAIN_POSITIVE_ELEMENT,
                        webDefect(translations.allElementsAreNegative()))
                .register(INTEREST_LIMIT_EXCEEDED,
                        webDefect(translations.interestLimitExceeded(MAX_INTEREST_RULES_PER_CONDITION)))
                .register(CPM_YNDX_FRONTPAGE_RETARGETINGS_NOT_ALLOWED,
                        webDefect(retTranslations.cpmYndxFrontpageRetargetingsNotAllowed()))
                .register(INVALID_RETARGETING_CONDITION_IN_USER_PROFILE_FOR_TGO,
                        webDefect(translations.invalidRetargetingConditionInUserProfileInTgo()))

                .register(RETARGETING_CONDITION_ALREADY_EXISTS,
                        webDefect(translations.retargetingConditionAlreadyExists()))
                .register(DUPLICATED_GOAL,
                        webDefect(translations.duplicatedGoal()))
                .register(INVALID_RETARGETING_CONDITION,
                        webDefect(translations.retargetingConditionIsInvalidForRetargeting()))
                .register(INVALID_RETARGETING_CONDITION_BY_PRICE_PACKAGE,
                        webDefect(translations.retargetingConditionIsInvalidForPricePackage()))
                .register(INCONSISTENT_RETARGETING_CONDITION_BY_DEFAULT_ADGROUP,
                        webDefect(translations.retargetingConditionIsInvalidForDefaultAdGroup()))
                .register(RETARGETING_CONDITION_NOT_FOUND,
                        webDefect(translations.retargetingConditionNotFoundDetailed()))
                .register(RETARGETING_CONDITION_NOT_FOUND_WITH_ID,
                        paramWebDefect(di -> translations.retargetingConditionNotFoundDetailedWithId(
                                new Identity(di.getDefect().params().getId()))))
                .register(INCONSISTENT_STATE_TARGETING_CATEGORY,
                        webDefect(translations.inconsistentStateTargetingCategoryUnavailable()))
                .register(NOT_ELIGABLE_ADGROUP,
                        webDefect(translations.notEligibleAdGroupDetailed()))
                .register(DUPLICATED_RETARGETING_CONDITION_ID_FOR_ADGROUP_ID,
                        webDefect(translations.duplicatedRetargetingConditionIdForAdGroupId()))
                .register(MAX_SIZE_IN_ADGROUP,
                        paramWebDefect(di -> translations.adGroupLimitExceeded(
                                new Identity(di.getDefect().params().getMax().longValue()))))
                .register(MAX_SIZE_IN_CPM_ADGROUP,
                        paramWebDefect(di -> translations.cpmAdGroupLimitExceeded()))
                .register(MAX_SIZE_USER_PROFILE_IN_CPM_ADGROUP,
                        paramWebDefect(di -> translations.adGroupUserProfileLimitExceeded()))
                .register(MUTUALLY_EXCLUSIVE_PARAMETERS,
                        paramWebDefect(di -> translations.mutuallyExclusiveParametersTwoElements(
                                di.getDefect().params().getPath1(), di.getDefect().params().getPath2())))
                .register(LEAST_ONE_FIELD_REQUIRED,
                        paramWebDefect(di -> translations.requiredAtLeastOneOfFieldsTwoElements(
                                di.getDefect().params().getPath1(), di.getDefect().params().getPath2())))

                .register(WARNING_NOT_SUSPENDED,
                        webDefect(translations.notSuspendedRetargetingDetailed()))
                .register(WARNING_ALREADY_SUSPENDED,
                        webDefect(translations.alreadySuspendedRetargetingDetailed()))
                .register(WARNING_DUPLICATED_RETARGETING_ID,
                        webDefect(translations.duplicatedRetargetingId()))
                .register(ADGROUP_NOT_FOUND,
                        paramWebDefect(di -> translations.adGroupNotFoundDetailed(
                                new Identity(di.getDefect().params().getId()))))
                .register(NO_RIGHTS_IN_ARCHIVED_ADGROUP,
                        webDefect(retTranslations.retargetingModificationInArchivedAdGroup()))
                .register(AUDIENCE_TARGET_ALLOWED_IN_MOBILE_CONTENT_CAMPAIGN,
                        webDefect(retTranslations.audienceTargetAllowedInMobileContentCampaign()))
                .register(CAMPAIGN_STATUS_ARCHIVED_ON_ADD,
                        paramWebDefect(di -> translations.badCampaignStatusArchived(
                                new Identity(di.getDefect().params().getId()))))
                .register(CAMPAIGN_STATUS_ARCHIVED_ON_DELETE,
                        paramWebDefect(di -> translations.cantRemoveAudienceTargetFromArchivedCampaignDetailed(
                                di.getDefect().params().getId())))
                .register(CAMPAIGN_STATUS_ARCHIVED_ON_SUSPEND,
                        paramWebDefect(di -> translations.badCampaignStatusArchivedOnSuspend(
                                new Identity(di.getDefect().params().getId()))))
                .register(CAMPAIGN_STATUS_ARCHIVED_ON_RESUME,
                        paramWebDefect(di -> translations.badCampaignStatusArchivedOnResume(
                                new Identity(di.getDefect().params().getId()))))

                .register(DUPLICATED_OBJECT_WITH_RULES,
                        webDefect(translations.duplicatedRetConditionRulesDetailed()))
                .build();
    }
}
