package ru.yandex.direct.web.entity.retargetinglists.controller;


import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.entity.retargeting.model.ConditionType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionActionResponse;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionWeb;
import ru.yandex.direct.web.core.security.captcha.CaptchaLimits;
import ru.yandex.direct.web.core.security.captcha.CaptchaSecured;
import ru.yandex.direct.web.core.security.captcha.DisableAutoCaptcha;
import ru.yandex.direct.web.core.security.csrf.CsrfCheck;
import ru.yandex.direct.web.entity.retargetinglists.model.GoalsForRetargetingResponse;
import ru.yandex.direct.web.entity.retargetinglists.model.ReplaceGoal;
import ru.yandex.direct.web.entity.retargetinglists.model.SwitchRetargetingWeb;
import ru.yandex.direct.web.entity.retargetinglists.service.CreateRetargetingConditionsService;
import ru.yandex.direct.web.entity.retargetinglists.service.DeleteRetargetingConditionsService;
import ru.yandex.direct.web.entity.retargetinglists.service.EstimateRetargetingConditionService;
import ru.yandex.direct.web.entity.retargetinglists.service.GetRetCondWithGoalsService;
import ru.yandex.direct.web.entity.retargetinglists.service.GetRetargetingGoalsService;
import ru.yandex.direct.web.entity.retargetinglists.service.ReplaceGoalsInRetargetingsService;
import ru.yandex.direct.web.entity.retargetinglists.service.SwitchRetargetingConditionsService;
import ru.yandex.direct.web.entity.retargetinglists.service.UpdateRetargetingConditionsService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;
import static ru.yandex.direct.web.core.security.captcha.CaptchaConditionKey.UID_VALUE;

@Controller
@RequestMapping(value = "/retargeting",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "retargeting")
public class RetargetingController {
    private final GetRetargetingGoalsService getRetargetingGoalsService;
    private final GetRetCondWithGoalsService getRetCondWithGoalsService;
    private final CreateRetargetingConditionsService createRetargetingConditionsService;
    private final UpdateRetargetingConditionsService updateRetargetingConditionsService;
    private final DeleteRetargetingConditionsService deleteRetargetingConditionsService;
    private final ReplaceGoalsInRetargetingsService replaceGoalsInRetargetingsService;
    private final EstimateRetargetingConditionService estimateRetargetingConditionService;
    private final SwitchRetargetingConditionsService switchRetargetingOnBannersService;

    @Autowired
    public RetargetingController(
            GetRetargetingGoalsService getRetargetingGoalsService,
            GetRetCondWithGoalsService getRetCondWithGoalsService,
            CreateRetargetingConditionsService createRetargetingConditionsService,
            UpdateRetargetingConditionsService updateRetargetingConditionsService,
            DeleteRetargetingConditionsService deleteRetargetingConditionsService,
            EstimateRetargetingConditionService estimateRetargetingConditionService,
            SwitchRetargetingConditionsService switchRetargetingOnBannersService,
            ReplaceGoalsInRetargetingsService replaceGoalsInRetargetingsService) {
        this.getRetargetingGoalsService = getRetargetingGoalsService;
        this.getRetCondWithGoalsService = getRetCondWithGoalsService;
        this.createRetargetingConditionsService = createRetargetingConditionsService;
        this.updateRetargetingConditionsService = updateRetargetingConditionsService;
        this.deleteRetargetingConditionsService = deleteRetargetingConditionsService;
        this.replaceGoalsInRetargetingsService = replaceGoalsInRetargetingsService;
        this.estimateRetargetingConditionService = estimateRetargetingConditionService;
        this.switchRetargetingOnBannersService = switchRetargetingOnBannersService;
    }

    @ApiOperation(
            value = "createRetargetingCondition",
            httpMethod = "POST",
            nickname = "createRetargetingCondition"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = RetargetingConditionActionResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/condition/create",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    @CsrfCheck(enabled = false)
    public WebResponse createRetargetingCondition(@RequestBody RetargetingConditionWeb retargetingConditionWeb,
                                                  @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return createRetargetingConditionsService.createCondition(retargetingConditionWeb);
    }


    @ApiOperation(
            value = "updateRetargetingCondition",
            httpMethod = "POST",
            nickname = "updateRetargetingCondition"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = RetargetingConditionActionResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/condition/update",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse updateRetargetingCondition(@RequestBody RetargetingConditionWeb retargetingConditionWeb,
                                                  @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return updateRetargetingConditionsService.updateCondition(retargetingConditionWeb);
    }


    @ApiOperation(
            value = "replaceGoalsInRetargetings",
            httpMethod = "POST",
            nickname = "replaceGoalsInRetargetings"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/replace-goals",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse replaceGoalsInRetargetings(@RequestBody List<ReplaceGoal> replaceGoals,
                                                  @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return replaceGoalsInRetargetingsService.replaceGoalsInRetargetings(replaceGoals);
    }


    @ApiOperation(
            value = "deleteRetargetingCondition",
            httpMethod = "POST",
            nickname = "deleteRetargetingCondition"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/condition/delete", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse deleteRetargetingCondition(@RequestBody List<Long> retCondIds,
                                                  @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return deleteRetargetingConditionsService.deleteConditions(retCondIds);
    }


    @ApiOperation(
            value = "getGoalsForRetargeting",
            httpMethod = "GET",
            nickname = "getGoalsForRetargeting"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = GoalsForRetargetingResponse.class)
            }
    )
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @RequestMapping(path = "/goals", method = RequestMethod.GET)
    @ResponseBody
    public GoalsForRetargetingResponse getGoalsForRetargeting(
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return new GoalsForRetargetingResponse().withResult(getRetargetingGoalsService.getMetrikaGoalsForRetargeting());
    }


    @ApiOperation(
            value = "ajaxGetRetCondWithGoals",
            httpMethod = "GET",
            nickname = "ajaxGetRetCondWithGoals"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebResponse.class)
            }
    )
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @RequestMapping(path = "/condition", method = RequestMethod.GET)
    @ResponseBody
    public WebResponse getRetCondWithGoals(@RequestParam(required = false) List<Long> retargetingConditionIds,
                                           @RequestParam(required = false) List<Long> adGroupIds, @RequestParam(required = false) String filter,
                                           @RequestParam(required = false) ConditionType type,
                                           @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return getRetCondWithGoalsService.getRetCondWithGoals(retargetingConditionIds, adGroupIds, filter, type);
    }


    @ApiOperation(
            value = "switchRetargetingConditions",
            httpMethod = "POST",
            nickname = "switchRetargetingConditions"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/switch", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse switchRetargetingConditions(@RequestBody List<SwitchRetargetingWeb> retCondIds,
                                                   @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return switchRetargetingOnBannersService.switchRetargetingConditions(retCondIds);
    }


    @ApiOperation(
            value = "suspendRetargetingConditions",
            httpMethod = "POST",
            nickname = "suspendRetargetingConditions"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/suspend", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse suspendRetargetingOnBanners(@RequestBody List<Long> retCondIds,
                                                   @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return switchRetargetingOnBannersService.switchRetargetingConditions(retCondIds, true);
    }


    @ApiOperation(
            value = "unsuspendRetargetingConditions",
            httpMethod = "POST",
            nickname = "unsuspendRetargetingConditions"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @PreAuthorizeWrite
    @DisableAutoCaptcha
    @RequestMapping(path = "/unsuspend", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse unsuspendRetargetingConditions(@RequestBody List<Long> retCondIds,
                                                      @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return switchRetargetingOnBannersService.switchRetargetingConditions(retCondIds, false);
    }


    @ApiOperation(
            value = "retargetingCondEstimate",
            httpMethod = "POST",
            nickname = "retargetingCondEstimate"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebErrorResponse.class)
            }
    )
    @PreAuthorizeRead
    @DisableAutoCaptcha
    @CaptchaSecured(
            keys = UID_VALUE, limits = @CaptchaLimits(freq = 100, interval = 3600, maxFreq = 4000))
    @RequestMapping(path = "/condition/estimate", method = RequestMethod.POST)
    @ResponseBody
    public WebResponse retargetingCondEstimate(@RequestBody RetargetingConditionWeb retargetingConditionWeb,
                                               @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) String subjectLogin) {
        return estimateRetargetingConditionService.retargetingConditionEstimate(retargetingConditionWeb);
    }
}
