package ru.yandex.direct.web.entity.retargetinglists.presentations;

import ru.yandex.direct.core.entity.retargeting.container.ReplaceRetargetingConditionGoal;
import ru.yandex.direct.core.entity.retargeting.container.SwitchRetargeting;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.core.model.retargeting.AbstractGoalWeb;
import ru.yandex.direct.web.core.model.retargeting.Condition;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionWeb;
import ru.yandex.direct.web.entity.retargetinglists.model.ReplaceGoal;
import ru.yandex.direct.web.entity.retargetinglists.model.SwitchRetargetingWeb;

public class RetargetingPresentations {

    public static final MappingPathNodeConverter RETARGETING_GOAL_PRESENTATION =
            MappingPathNodeConverter.builder(RetargetingPresentations.class.getName())
                    .replace(Goal.ID.name(), AbstractGoalWeb.ID_FIELD_NAME)
                    .replace(Goal.TYPE.name(), AbstractGoalWeb.TYPE_FIELD_NAME)
                    .replace(Goal.TIME.name(), Goal.TIME.name())
                    .replace(Goal.UNION_WITH_ID.name(), AbstractGoalWeb.UNION_WITH_ID_FIELD_NAME)
                    .build();

    public static final MappingPathNodeConverter RETARGETING_CONDITION_PRESENTATION =
            MappingPathNodeConverter.builder(RetargetingPresentations.class.getName())
                    .replace(RetargetingCondition.RULES.name(), RetargetingConditionWeb.CONDITIONS_FIELD_NAME)
                    .replace(RetargetingCondition.DESCRIPTION.name(), RetargetingConditionWeb.DESCRIPTION_FIELD_NAME)
                    .replace(RetargetingCondition.ID.name(), RetargetingConditionWeb.ID_FIELD_NAME)
                    .replace(RetargetingCondition.NAME.name(), RetargetingConditionWeb.NAME_FIELD_NAME)
                    .replace(RetargetingCondition.CLIENT_ID.name(), RetargetingConditionWeb.CLIENT_ID_FIELD_NAME)
                    .replace(RetargetingCondition.AVAILABLE.name(), RetargetingConditionWeb.IS_ACCESSIBLE_FIELD_NAME)
                    .build();

    public static final MappingPathNodeConverter RETARGETING_CONDITION_RULE_PRESENTATION =
            MappingPathNodeConverter.builder(RetargetingPresentations.class.getName())
                    .replace(Rule.GOALS.name(), Condition.GOALS_FIELD_NAME)
                    .replace(Rule.TYPE.name(), Condition.TYPE_FIELD_NAME)
                    .replace(Rule.INTEREST_TYPE.name(), Condition.INTEREST_TYPE_FIELD_NAME)
                    .build();

    public static final MappingPathNodeConverter REPLACE_RETARGETING_CONDITION_GOAL_PRESENTATION =
            MappingPathNodeConverter.builder(RetargetingPresentations.class.getName())
                    .replace(ReplaceRetargetingConditionGoal.NEW_GOAL_ID.name(), ReplaceGoal.NEW_GOAL_ID)
                    .replace(ReplaceRetargetingConditionGoal.OLD_GOAL_ID.name(), ReplaceGoal.OLD_GOAL_ID)
                    .build();

    public static final MappingPathNodeConverter SWITCH_RETARGETING_PRESENTATION =
            MappingPathNodeConverter.builder(RetargetingPresentations.class.getName())
                    .replace(SwitchRetargeting.IS_SUSPENDED.name(), SwitchRetargetingWeb.IS_SUSPENDED)
                    .replace(SwitchRetargeting.RET_COND_ID.name(), SwitchRetargetingWeb.RET_COND_ID)
                    .build();
}
