package ru.yandex.direct.web.entity.retargetinglists.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionActionResponse;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionWeb;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.validation.kernel.ValidationResultConversionService;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.core.validation.ValidationUtils.hasValidationIssues;
import static ru.yandex.direct.web.core.model.retargeting.RetargetingConditionConverter.toRetargetingCondition;

@Service
public class CreateRetargetingConditionsService {
    private static final Logger logger = LoggerFactory.getLogger(CreateRetargetingConditionsService.class);

    private final RetargetingConditionService retargetingConditionService;
    private final DirectWebAuthenticationSource authenticationSource;
    private final RetargetingConditionWebValidationService retargetingConditionValidator;
    private final ValidationResultConversionService validationResultConversionService;

    @Autowired
    public CreateRetargetingConditionsService(RetargetingConditionService retargetingConditionService,
                                              DirectWebAuthenticationSource authenticationSource,
                                              RetargetingConditionWebValidationService retargetingConditionValidator,
                                              ValidationResultConversionService validationResultConversionService) {
        this.retargetingConditionService = retargetingConditionService;
        this.authenticationSource = authenticationSource;
        this.retargetingConditionValidator = retargetingConditionValidator;
        this.validationResultConversionService = validationResultConversionService;
    }

    public WebResponse createCondition(RetargetingConditionWeb retargetingConditionWeb) {
        DirectAuthentication authentication = authenticationSource.getAuthentication();
        ClientId clientId = authentication.getSubjectUser().getClientId();
        long uid = authentication.getSubjectUser().getUid();
        logger.debug("uid: {}, clientId: {}", uid, clientId);

        return createCondition(retargetingConditionWeb, clientId);
    }

    public WebResponse createCondition(RetargetingConditionWeb retargetingConditionWeb, ClientId clientId) {
        ValidationResult<RetargetingConditionWeb, Defect> preValidationResult =
                retargetingConditionValidator.validate(retargetingConditionWeb);

        if (preValidationResult.hasAnyErrors()) {
            return validationResultConversionService.buildValidationResponse(preValidationResult);
        }

        RetargetingCondition coreRetargetingCondition = toRetargetingCondition(retargetingConditionWeb, clientId);

        MassResult<Long> operationResult = retargetingConditionService.addRetargetingConditions(
                singletonList(coreRetargetingCondition), clientId, Applicability.FULL, false);

        if (hasValidationIssues(operationResult)) {
            return validationResultConversionService.buildSingleValidationResponse(operationResult);
        }

        return new RetargetingConditionActionResponse(coreRetargetingCondition.getId());
    }
}
