package ru.yandex.direct.web.entity.retargetinglists.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.retargeting.model.ConditionType;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionMappings;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbschema.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionConverter;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.entity.retargetinglists.model.GetRetCondWithGoalsResponse;
import ru.yandex.direct.web.validation.kernel.ValidationResultConversionService;

import static java.util.Collections.singleton;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
public class GetRetCondWithGoalsService {
    private static final Logger logger = LoggerFactory.getLogger(GetRetCondWithGoalsService.class);

    private final DirectWebAuthenticationSource authenticationSource;
    private final RetargetingConditionService retargetingConditionService;
    private final GetRetCondWithGoalsValidationService getRetCondWithGoalsValidationService;
    private final ValidationResultConversionService validationResultConversionService;


    public GetRetCondWithGoalsService(DirectWebAuthenticationSource authenticationSource,
                                      RetargetingConditionService retargetingConditionService,
                                      GetRetCondWithGoalsValidationService getRetCondWithGoalsValidationService,
                                      ValidationResultConversionService validationResultConversionService) {
        this.authenticationSource = authenticationSource;
        this.retargetingConditionService = retargetingConditionService;
        this.getRetCondWithGoalsValidationService = getRetCondWithGoalsValidationService;
        this.validationResultConversionService = validationResultConversionService;
    }

    public WebResponse getRetCondWithGoals(List<Long> retargetingConditionIds, List<Long> adGroupIds, String filter,
                                           ConditionType type) {
        User subClient = authenticationSource.getAuthentication().getSubjectUser();
        logger.debug("uid: {}, clientId: {}", subClient.getUid(), subClient.getClientId());
        ValidationResult<List<Long>, Defect> preValidationResult =
                getRetCondWithGoalsValidationService.validate(retargetingConditionIds);
        if (preValidationResult.hasAnyErrors()) {
            return validationResultConversionService.buildValidationResponse(preValidationResult);
        }

        RetargetingConditionsRetargetingConditionsType conditionType
                = RetargetingConditionMappings.conditionTypeToDb(type);
        List<RetargetingCondition> retargetingConditions = retargetingConditionService
                .getRetargetingConditionsWithFullGoals(retargetingConditionIds, subClient.getClientId(), adGroupIds,
                        filter, conditionType == null ? null : singleton(conditionType));

        return new GetRetCondWithGoalsResponse()
                .withResult(mapList(retargetingConditions, RetargetingConditionConverter::fromRetargetingCondition));
    }
}
