package ru.yandex.direct.web.entity.retargetinglists.service;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefects;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Service
public class GetRetCondWithGoalsValidationService {

    public static final int MAX_LIST_SIZE = 10_000;

    public ValidationResult<List<Long>, Defect> validate(List<Long> retargetingConditionIds) {
        return ListValidationBuilder.of(retargetingConditionIds, Defect.class)
                .check(maxListSize(MAX_LIST_SIZE), RetargetingDefects.maxIdsInSelection())
                .checkEach(notNull())
                .getResult();
    }
}
