package ru.yandex.direct.web.entity.retargetinglists.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import ru.yandex.direct.core.entity.retargeting.container.ReplaceRetargetingConditionGoal;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.entity.retargetinglists.model.ReplaceGoal;
import ru.yandex.direct.web.entity.retargetinglists.model.ReplaceGoalConverter;
import ru.yandex.direct.web.validation.kernel.ValidationResultConversionService;

import static ru.yandex.direct.core.validation.ValidationUtils.hasValidationIssues;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;


@Service
public class ReplaceGoalsInRetargetingsService {
    private static final Logger logger = LoggerFactory.getLogger(ReplaceGoalsInRetargetingsService.class);

    private final DirectWebAuthenticationSource authenticationSource;
    private final RetargetingConditionOperationFactory retargetingConditionOperationFactory;
    private final ValidationResultConversionService validationResultConversionService;
    private final ReplaceGoalsInRetargetingsWebValidationService replaceGoalsInRetargetingsWebValidationService;

    @Autowired
    public ReplaceGoalsInRetargetingsService(
            DirectWebAuthenticationSource authenticationSource,
            RetargetingConditionOperationFactory retargetingConditionOperationFactory,
            ValidationResultConversionService validationResultConversionService,
            ReplaceGoalsInRetargetingsWebValidationService replaceGoalsInRetargetingsWebValidationService) {
        this.authenticationSource = authenticationSource;
        this.retargetingConditionOperationFactory = retargetingConditionOperationFactory;
        this.validationResultConversionService = validationResultConversionService;
        this.replaceGoalsInRetargetingsWebValidationService = replaceGoalsInRetargetingsWebValidationService;
    }

    public WebResponse replaceGoalsInRetargetings(@RequestBody List<ReplaceGoal> replaceGoals) {
        User subclient = authenticationSource.getAuthentication().getSubjectUser();
        logger.debug("uid: {}, clientId: {}", subclient.getUid(), subclient.getClientId());

        ValidationResult<List<ReplaceGoal>, Defect> preValidationResult =
                replaceGoalsInRetargetingsWebValidationService.validate(replaceGoals);

        if (preValidationResult.hasAnyErrors()) {
            return validationResultConversionService.buildValidationResponse(preValidationResult);
        }

        Result<List<ReplaceRetargetingConditionGoal>> operationResult =
                retargetingConditionOperationFactory.replaceGoalsInRetargetings(
                        subclient.getClientId(),
                        mapList(replaceGoals, ReplaceGoalConverter::toReplaceRetargetingConditionGoal));

        if (hasValidationIssues(operationResult)) {
            return validationResultConversionService.buildValidationResponse(operationResult);
        }

        return new WebSuccessResponse();
    }
}
