package ru.yandex.direct.web.entity.retargetinglists.service;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.core.model.retargeting.AbstractGoalWeb;
import ru.yandex.direct.web.core.model.retargeting.Condition;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionWeb;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;


@Service
public class RetargetingConditionWebValidationService {
    public ValidationResult<RetargetingConditionWeb, Defect> validate(RetargetingConditionWeb clientModel) {
        ItemValidationBuilder<RetargetingConditionWeb, Defect> vb = ItemValidationBuilder.of(clientModel);
        vb.check(notNull());
        if (!vb.getResult().hasAnyErrors()) {
            vb.list(clientModel.getConditions(),
                    RetargetingCondition.RULES.name())
                    .checkEachBy(this::validateRetConditionRule, When.isValid());
        }
        return vb.getResult();
    }

    private ValidationResult<Condition, Defect> validateRetConditionRule(Condition conditionBase) {
        ItemValidationBuilder<Condition, Defect> vb =
                ItemValidationBuilder.of(conditionBase, Defect.class);
        vb.check(notNull());

        if (!vb.getResult().hasAnyErrors()) {
            vb.list(conditionBase.getConditionGoalWebs(), Rule.GOALS.name())
                    .checkEachBy(this::validateConditionGoal);
        }
        return vb.getResult();
    }

    private ValidationResult<AbstractGoalWeb, Defect> validateConditionGoal(AbstractGoalWeb goalWeb) {
        ItemValidationBuilder<AbstractGoalWeb, Defect> vb = ItemValidationBuilder.of(goalWeb, Defect.class);
        vb.check(notNull());
        if (!vb.getResult().hasAnyErrors()) {
            vb.item(goalWeb.getId(), AbstractGoalWeb.ID_FIELD_NAME).check(notNull());
        }
        return vb.getResult();
    }
}
