package ru.yandex.direct.web.entity.retargetinglists.service;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.entity.retargetinglists.model.SwitchRetargetingWeb;

import static ru.yandex.direct.validation.constraint.CommonConstraints.eachNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;


@Service
public class SwitchRetargetingConditionValidationService {
    public ValidationResult<List<SwitchRetargetingWeb>, Defect> validate(
            List<SwitchRetargetingWeb> switchRetargetingWebList) {
        ItemValidationBuilder<List<SwitchRetargetingWeb>, Defect> vb =
                ItemValidationBuilder.of(switchRetargetingWebList, Defect.class);
        vb.check(notNull());
        vb.check(eachNotNull(), When.notNull());
        return vb.getResult();
    }
}
