package ru.yandex.direct.web.entity.sitelink.presentation;

import ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.WebDefectTranslations;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.DUPLICATE_SITELINK_DESCS;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.DUPLICATE_SITELINK_TITLES;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.INVALID_SITELINK_HREF;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.MAX_ELEMENTS_PER_DELETE_REQUEST;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.REQUIRED_SITELINK_WITH_TURBO_HREF_OR_TURBOLANDING_ID;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.SITELINK_DESCRIPTION_CANNOT_BE_EMPTY;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Gen.SITELINK_TITLE_CANNOT_BE_EMPTY;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_DESC;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_TITLE;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.MAX_SITELINKS_FIRST_BLOCK_TITLES_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.MAX_SITELINKS_SECOND_BLOCK_TITLES_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.MAX_SITELINKS_TITLES_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.SITELINK_DESCRIPTION_LENGTH_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.SITELINK_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds.Strings.SITELINK_TITLE_LENGTH_CANNOT_BE_MORE_THAN_MAX;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetDefectIds.Collections.SITELINKS_COUNT_MUST_BE_BETWEEN;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetDefectIds.Gen.DUPLICATE_SITELINK_SET;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetDefectIds.Gen.SITELINKS_SET_USED_AND_CANT_BE_DELETED;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class SitelinkDefectPresentations {

    private SitelinkDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> sitelinkDefectPresentationRegistry() {
        SitelinkDefectTranslations translations = SitelinkDefectTranslations.INSTANCE;
        WebDefectTranslations webTranslations = WebDefectTranslations.INSTANCE;
        CommonDefectTranslations commonTranslations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()

                //sitelinks
                .register(MAX_SITELINKS_TITLES_LENGTH,
                        defaultWebDefect())
                .register(MAX_SITELINKS_FIRST_BLOCK_TITLES_LENGTH,
                        defaultWebDefect())
                .register(MAX_SITELINKS_SECOND_BLOCK_TITLES_LENGTH,
                        defaultWebDefect())
                .register(ALLOWED_SYMBOLS_SITELINK_TITLE,
                        webDefect(translations.notAllowedSymbolsInSitelinkTitle()))
                .register(ALLOWED_SYMBOLS_SITELINK_DESC,
                        webDefect(translations.notAllowedSymbolsInSitelinkDesc()))
                .register(SITELINK_TITLE_CANNOT_BE_EMPTY,
                        defaultWebDefect())
                .register(SITELINK_DESCRIPTION_CANNOT_BE_EMPTY,
                        webDefect(webTranslations.INSTANCE.fieldIsRequired()))
                .register(SITELINK_DESCRIPTION_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        webDefect(webTranslations.stringLengthMustNotExceed()))
                .register(INVALID_SITELINK_HREF, defaultWebDefect())
                .register(REQUIRED_SITELINK_WITH_TURBO_HREF_OR_TURBOLANDING_ID, defaultWebDefect())
                .register(SITELINK_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        webDefect(webTranslations.stringLengthMustNotExceed()))
                .register(SITELINK_TITLE_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        webDefect(webTranslations.stringLengthMustNotExceed()))

                //sitelinkSets
                // почему тогда id дефектов лежат в SitelinkDefectIds?
                .register(SITELINKS_SET_USED_AND_CANT_BE_DELETED,
                        defaultWebDefect())
                .register(DUPLICATE_SITELINK_TITLES,
                        webDefect(translations.duplicateSitelinkTitles()))
                .register(DUPLICATE_SITELINK_DESCS,
                        webDefect(translations.duplicateSitelinkDescs()))
                .register(MAX_ELEMENTS_PER_DELETE_REQUEST,
                        webDefect(commonTranslations.maxElementsExceededShort()))
                .register(OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST,
                        webDefect(commonTranslations.duplicatedObjectShort()))
                .register(DUPLICATE_SITELINK_SET,
                        webDefect(commonTranslations.duplicatedObjectShort()))
                .register(SITELINKS_COUNT_MUST_BE_BETWEEN,
                        webDefect(webTranslations.collectionSizeMustBeInInterval()))
                .build();
    }
}
