package ru.yandex.direct.web.entity.smsauth;

import java.security.SecureRandom;

import com.google.common.math.IntMath;

import ru.yandex.direct.web.entity.smsauth.model.sendsms.SendSmsResult;
import ru.yandex.direct.yasms.model.YaSmsSendSmsResponse;

/**
 * Utils класс для {@link ru.yandex.direct.web.entity.smsauth.service.SmsAuthService}
 */
public class SmsAuthUtils {

    private static final SecureRandom RANDOM = new SecureRandom();

    private static final String SMS_FORMAT = "%s - ваш одноразовый пароль для работы с мастер-токеном в Яндекс.Директе.";

    static final int SMS_PASSWORD_LENGTH = 6;

    private static final String SMS_PASSWORD_FORMAT = "%0" + SMS_PASSWORD_LENGTH + "d";
    private static final int SMS_PASSWORD_BOUND = IntMath.pow(10, SMS_PASSWORD_LENGTH);

    /**
     * Генерирует случайный пароль для отправки через смс.
     *
     * @return случайный пароль
     */
    public static String generateRandomSmsPassword() {
        return String.format(SMS_PASSWORD_FORMAT, RANDOM.nextInt(SMS_PASSWORD_BOUND));
    }

    /**
     * Возвращает текст смс.
     *
     * @param password  пароль, который будет отправлен через смс
     * @return текст смс
     */
    public static String getSmsMessage(String password) {
        return String.format(SMS_FORMAT, password);
    }

    /**
     * Конвертирует ответ от YaSms в ответ Директа.
     *
     * @param response  ответ от YaSms
     * @return ответ в директовом формате
     */
    public static SendSmsResult convert(YaSmsSendSmsResponse response) {
        return response.isSuccessful() ?
                SendSmsResult.ofSuccess(response.getMessageSent().getId())
                : SendSmsResult.ofError(response.getError(), response.getErrorCode().name());
    }
}
