package ru.yandex.direct.web.entity.smsauth.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.entity.smsauth.model.checkpassword.CheckPasswordRequest;
import ru.yandex.direct.web.entity.smsauth.model.getsmsphone.GetSmsPhoneResponse;
import ru.yandex.direct.web.entity.smsauth.model.sendsms.SendSmsByPhoneIdRequest;
import ru.yandex.direct.web.entity.smsauth.model.sendsms.SendSmsResponse;
import ru.yandex.direct.web.entity.smsauth.service.SmsAuthControllerService;

import static ru.yandex.direct.rbac.RbacRole.AGENCY;
import static ru.yandex.direct.rbac.RbacRole.CLIENT;

@RestController
@RequestMapping(value = "/sms_auth")
@AllowedSubjectRoles({CLIENT, AGENCY})
@Api(tags = "smsAuth")
public class SmsAuthController {

    private final SmsAuthControllerService smsAuthControllerService;

    @Autowired
    public SmsAuthController(SmsAuthControllerService smsAuthControllerService) {
        this.smsAuthControllerService = smsAuthControllerService;
    }

    @ApiOperation(
            value = "getSmsPhone",
            httpMethod = "GET",
            nickname = "getSmsPhone"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 500, message = "Internal server error", response = WebErrorResponse.class),
                    @ApiResponse(code = 501, message = "Not implemented", response = WebErrorResponse.class),
                    @ApiResponse(code = 504, message = "Gateway Timeout", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = GetSmsPhoneResponse.class)
            }
    )
    @RequestMapping(path = "/get_sms_phone",
            method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseEntity<WebResponse> getSmsPhone() {
        return smsAuthControllerService.getSmsPhone();
    }

    @ApiOperation(
            value = "sendSms",
            httpMethod = "POST",
            nickname = "sendSms"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 500, message = "Internal server error", response = WebErrorResponse.class),
                    @ApiResponse(code = 501, message = "Not implemented", response = WebErrorResponse.class),
                    @ApiResponse(code = 504, message = "Gateway Timeout", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = SendSmsResponse.class)
            }
    )
    @RequestMapping(path = "/send_sms",
            method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseEntity<WebResponse> sendSms(@RequestBody SendSmsByPhoneIdRequest request) {
        return smsAuthControllerService.sendSms(request);
    }

    @ApiOperation(
            value = "checkPassword",
            httpMethod = "POST",
            nickname = "checkPassword"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 500, message = "Internal server error", response = WebErrorResponse.class),
                    @ApiResponse(code = 501, message = "Not implemented", response = WebErrorResponse.class),
                    @ApiResponse(code = 504, message = "Gateway Timeout", response = WebErrorResponse.class),
            }
    )
    @RequestMapping(path = "/check_password",
            method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseEntity<WebResponse> checkPassword(@RequestBody CheckPasswordRequest request) {
        return smsAuthControllerService.checkPassword(request);
    }
}
