package ru.yandex.direct.web.entity.smsauth.model.sendsms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SendSmsResult {

    @ApiModelProperty(notes = "id отправленной смс")
    @JsonProperty("smsId")
    private String smsId;

    @ApiModelProperty(notes = "текст ошибки отправки смс")
    @JsonProperty("error")
    private String error;

    @ApiModelProperty(notes = "код ошибки отправки смс")
    @JsonProperty("errorCode")
    private String errorCode;

    public SendSmsResult() {
    }

    public static SendSmsResult ofSuccess(String smsId) {
        return new SendSmsResult(smsId);
    }

    public static SendSmsResult ofError(String error, String errorCode) {
        return new SendSmsResult(error, errorCode);
    }

    private SendSmsResult(String smsId) {
        this.smsId = smsId;
    }

    private SendSmsResult(String error, String errorCode) {
        this.error = error;
        this.errorCode = errorCode;
    }

    public String getSmsId() {
        return smsId;
    }

    public String getError() {
        return error;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public boolean isSuccessful() {
        return smsId != null;
    }
}
