package ru.yandex.direct.web.entity.smsauth.presentations;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectTranslations;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.INCORRECT_PASSWORD;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.INVALID_USER_PHONE;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.NO_RETRIES_LEFT;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.SESSION_ALREADY_LOCKED;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.SMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.SMS_NOT_SENT_YET;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class SmsAuthDefectPresentations {

    private SmsAuthDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> smsAuthDefectPresentationRegistry() {
        SmsAuthDefectTranslations translations = SmsAuthDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(SESSION_ALREADY_LOCKED,
                        webDefect(translations.sessionAlreadyLocked()))
                .register(SMS_LIMIT_EXCEEDED,
                        webDefect(translations.smsDailyLimitExceeded()))
                .register(INVALID_USER_PHONE,
                        webDefect(translations.incorrectUserPhone()))
                .register(SMS_NOT_SENT_YET,
                        webDefect(translations.smsNotSent()))
                .register(NO_RETRIES_LEFT,
                        webDefect(translations.noRetriesLeft()))
                .register(INCORRECT_PASSWORD,
                        webDefect(translations.incorrectPassword()))
                .build();
    }
}
