package ru.yandex.direct.web.entity.smsauth.validation;

import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.INCORRECT_PASSWORD;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.INVALID_USER_PHONE;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.NO_RETRIES_LEFT;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.SESSION_ALREADY_LOCKED;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.SMS_LIMIT_EXCEEDED;
import static ru.yandex.direct.web.entity.smsauth.validation.SmsAuthDefectIds.UserDefects.SMS_NOT_SENT_YET;

public class SmsAuthDefects {

    public static Defect<Void> sessionAlreadyLocked() {
        return new Defect<>(SESSION_ALREADY_LOCKED);
    }

    public static Defect<Void> incorrectUserPhoneId() {
        return new Defect<>(INVALID_USER_PHONE);
    }

    public static Defect<Void> smsLimitExceeded() {
        return new Defect<>(SMS_LIMIT_EXCEEDED);
    }

    public static Defect<Void> smsNotSent() {
        return new Defect<>(SMS_NOT_SENT_YET);
    }

    public static Defect<Void> noRetriesLeft() {
        return new Defect<>(NO_RETRIES_LEFT);
    }

    public static Defect<Void> incorrectPassword() {
        return new Defect<>(INCORRECT_PASSWORD);
    }
}
