package ru.yandex.direct.web.entity.stat.service;

import java.util.Locale;

import javax.annotation.Nullable;

import ru.yandex.direct.common.TranslationService;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class ConversionStatCsvHeaders {
    private static final ConversionStatTranslations TRANSLATIONS = ConversionStatTranslations.INSTANCE;

    private final TranslationService translationService;
    private final Locale locale;

    public ConversionStatCsvHeaders(TranslationService translationService, @Nullable Locale locale) {
        this.translationService = translationService;
        this.locale = nvl(locale, translationService.getLocale());
    }

    public String[] getAllHeaders() {
        return new String[]{
                String.format("cid - %s", translationService.translate(TRANSLATIONS.campaignId(), locale)),
                String.format("conversionDate - %s", translationService.translate(TRANSLATIONS.conversionDate(), locale)),
                String.format("goalId - %s", translationService.translate(TRANSLATIONS.goalId(), locale)),
                String.format("goalName - %s", translationService.translate(TRANSLATIONS.goalName(), locale)),
                String.format("attributionType - %s", translationService.translate(TRANSLATIONS.attributionType(), locale)),
                String.format("costTaxFree - %s", translationService.translate(TRANSLATIONS.costTaxFree(), locale)),
                String.format("goalsNum - %s", translationService.translate(TRANSLATIONS.goalsNum(), locale))
        };
    }

}
