package ru.yandex.direct.web.entity.transparencyreport.model;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TransparencyReportBanner {
    @JsonProperty("client_name")
    private String clientName;

    @JsonProperty("banner_id")
    private String bannerId;

    @JsonProperty("creative_id")
    private String creativeId;

    @JsonProperty("creative_date_start")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date creativeDateStart;

    @JsonProperty("creative_date_end")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date creativeDateEnd;

    @JsonProperty("creative_live_preview_url")
    private String creativeLivePreviewUrl;

    @JsonProperty("creative_preview_url")
    private String creativePreviewUrl;

    @JsonProperty("creative_type")
    private TransparencyReportCreativeType creativeType;

    @JsonProperty("creative_revenue")
    private Double creativeRevenue;

    @JsonProperty("creative_shows")
    private Long creativeShows;

    @JsonProperty("creative_height")
    private Long creativeHeight;

    @JsonProperty("creative_width")
    private Long creativeWidth;

    @JsonProperty("title")
    private String title;

    @JsonProperty("body")
    private String body;

    @JsonProperty("href")
    private String href;

    @JsonProperty("is_grant")
    private Boolean isGrant;

    @JsonProperty("image_data")
    private String imageData;

    public String getClientName() {
        return clientName;
    }

    public TransparencyReportBanner withClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public String getBannerId() {
        return bannerId;
    }

    public TransparencyReportBanner withBannerId(String bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public String getCreativeId() {
        return creativeId;
    }

    public TransparencyReportBanner withCreativeId(String creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public Date getCreativeDateStart() {
        return creativeDateStart;
    }

    public TransparencyReportBanner withCreativeDateStart(Date creativeDateStart) {
        this.creativeDateStart = creativeDateStart;
        return this;
    }

    public Date getCreativeDateEnd() {
        return creativeDateEnd;
    }

    public TransparencyReportBanner withCreativeDateEnd(Date creativeDateEnd) {
        this.creativeDateEnd = creativeDateEnd;
        return this;
    }

    public String getCreativeLivePreviewUrl() {
        return creativeLivePreviewUrl;
    }

    public TransparencyReportBanner withCreativeLivePreviewUrl(String creativeLivePreviewUrl) {
        this.creativeLivePreviewUrl = creativeLivePreviewUrl;
        return this;
    }

    public String getCreativePreviewUrl() {
        return creativePreviewUrl;
    }

    public TransparencyReportBanner withCreativePreviewUrl(String creativePreviewUrl) {
        this.creativePreviewUrl = creativePreviewUrl;
        return this;
    }

    public TransparencyReportCreativeType getCreativeType() {
        return creativeType;
    }

    public TransparencyReportBanner withCreativeType(TransparencyReportCreativeType creativeType) {
        this.creativeType = creativeType;
        return this;
    }

    public Double getCreativeRevenue() {
        return creativeRevenue;
    }

    public TransparencyReportBanner withCreativeRevenue(Double creativeRevenue) {
        this.creativeRevenue = creativeRevenue;
        return this;
    }

    public Long getCreativeShows() {
        return creativeShows;
    }

    public TransparencyReportBanner withCreativeShows(Long creativeShows) {
        this.creativeShows = creativeShows;
        return this;
    }

    public Long getCreativeHeight() {
        return creativeHeight;
    }

    public TransparencyReportBanner withCreativeHeight(Long creativeHeight) {
        this.creativeHeight = creativeHeight;
        return this;
    }

    public Long getCreativeWidth() {
        return creativeWidth;
    }

    public TransparencyReportBanner withCreativeWidth(Long creativeWidth) {
        this.creativeWidth = creativeWidth;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public TransparencyReportBanner withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getBody() {
        return body;
    }

    public TransparencyReportBanner withBody(String body) {
        this.body = body;
        return this;
    }

    public String getHref() {
        return href;
    }

    public TransparencyReportBanner withHref(String href) {
        this.href = href;
        return this;
    }

    public Boolean getIsGrant() {
        return isGrant;
    }

    public TransparencyReportBanner withIsGrant(Boolean isGrant) {
        this.isGrant = isGrant;
        return this;
    }

    public String getImageData() {
        return imageData;
    }

    public TransparencyReportBanner withImageData(String imageData) {
        this.imageData = imageData;
        return this;
    }
}
