package ru.yandex.direct.web.entity.transparencyreport.model;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class TransparencyReportBannersWithSummary {
    @JsonProperty("min_date_available")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date minDateAvailable;

    @JsonProperty("max_date_available")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date maxDateAvailable;

    @JsonProperty("is_end")
    private Boolean isEnd;

    @JsonProperty("creatives")
    private List<TransparencyReportBanner> banners;

    public Date getMinDateAvailable() {
        return minDateAvailable;
    }

    public TransparencyReportBannersWithSummary withMinDateAvailable(Date minDateAvailable) {
        this.minDateAvailable = minDateAvailable;
        return this;
    }

    public Date getMaxDateAvailable() {
        return maxDateAvailable;
    }

    public TransparencyReportBannersWithSummary withMaxDateAvailable(Date maxDateAvailable) {
        this.maxDateAvailable = maxDateAvailable;
        return this;
    }

    public Boolean getIsEnd() {
        return isEnd;
    }

    public TransparencyReportBannersWithSummary withIsEnd(Boolean isEnd) {
        this.isEnd = isEnd;
        return this;
    }

    public List<TransparencyReportBanner> getBanners() {
        return banners;
    }

    public TransparencyReportBannersWithSummary withBanners(List<TransparencyReportBanner> banners) {
        this.banners = banners;
        return this;
    }
}
