package ru.yandex.direct.web.entity.transparencyreport.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TransparencyReportCreativeType {
    IMAGE,
    HTML5,
    VIDEO;

    @JsonValue
    public String getValue() {
        return name().toLowerCase();
    }

    @JsonCreator
    public static TransparencyReportCreativeType fromString(@Nullable String creativeType) {
        return creativeType != null ? TransparencyReportCreativeType.valueOf(creativeType.toUpperCase()) : null;
    }
}
