package ru.yandex.direct.web.entity.transparencyreport.service;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportBanner;
import ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportCreativeType;

import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_BANNER_BODY;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_BANNER_DATE_END;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_BANNER_DATE_START;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_BANNER_HREF;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_BANNER_ID;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_BANNER_IS_GRANT;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_BANNER_TITLE;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_CREATIVE_HEIGHT;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_CREATIVE_ID;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_CREATIVE_LIVE_PREVIEW_URL;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_CREATIVE_PREVIEW_URL;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_CREATIVE_TYPE;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_CREATIVE_WIDTH;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_COLUMN_IMAGE_DATA;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_STATS_COLUMN_REVENUE;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_STATS_COLUMN_REVENUE_SUM_ALIAS;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_STATS_COLUMN_SHOWS;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_STATS_COLUMN_SHOWS_SUM_ALIAS;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.CLIENTS_COLUMN_CLIENT_NAME;

public class TransparencyReportBannersRowMapper implements RowMapper<TransparencyReportBanner> {
    @Override
    public TransparencyReportBanner mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();

        TransparencyReportBanner banner = new TransparencyReportBanner();

        for (int i = 1; i <= metaData.getColumnCount(); i++) {
            String columnName = metaData.getColumnName(i);
            switch (columnName) {
                case CLIENTS_COLUMN_CLIENT_NAME:
                    banner.withClientName(rs.getString(columnName));
                    break;
                case BANNERS_COLUMN_BANNER_ID:
                    banner.withBannerId(rs.getString(columnName));
                    break;
                case BANNERS_COLUMN_CREATIVE_ID:
                    banner.withCreativeId(rs.getString(columnName));
                    break;
                case BANNERS_COLUMN_CREATIVE_TYPE:
                    banner.withCreativeType(TransparencyReportCreativeType.fromString(
                            rs.getString(columnName)));
                    break;
                case BANNERS_COLUMN_CREATIVE_LIVE_PREVIEW_URL:
                    banner.withCreativeLivePreviewUrl(rs.getString(columnName));
                    break;
                case BANNERS_COLUMN_CREATIVE_PREVIEW_URL:
                    banner.withCreativePreviewUrl(rs.getString(columnName));
                    break;
                case BANNERS_COLUMN_BANNER_DATE_START:
                    banner.withCreativeDateStart(rs.getDate(columnName));
                    break;
                case BANNERS_COLUMN_BANNER_DATE_END:
                    banner.withCreativeDateEnd(rs.getDate(columnName));
                    break;
                case BANNERS_STATS_COLUMN_REVENUE_SUM_ALIAS:
                case BANNERS_STATS_COLUMN_REVENUE:
                    banner.withCreativeRevenue(rs.getDouble(columnName));
                    break;
                case BANNERS_STATS_COLUMN_SHOWS_SUM_ALIAS:
                case BANNERS_STATS_COLUMN_SHOWS:
                    banner.withCreativeShows(rs.getLong(columnName));
                    break;
                case BANNERS_COLUMN_CREATIVE_HEIGHT:
                    banner.withCreativeHeight(rs.getLong(columnName));
                    break;
                case BANNERS_COLUMN_CREATIVE_WIDTH:
                    banner.withCreativeWidth(rs.getLong(columnName));
                    break;
                case BANNERS_COLUMN_BANNER_TITLE:
                    banner.withTitle(rs.getString(columnName));
                    break;
                case BANNERS_COLUMN_BANNER_BODY:
                    banner.withBody(rs.getString(columnName));
                    break;
                case BANNERS_COLUMN_BANNER_HREF:
                    banner.withHref(rs.getString(columnName));
                    break;
                case BANNERS_COLUMN_BANNER_IS_GRANT:
                    banner.withIsGrant(rs.getInt(columnName) != 0);
                    break;
                case BANNERS_COLUMN_IMAGE_DATA:
                    banner.withImageData(rs.getString(columnName));
                    break;
                default:
                    break;
            }
        }

        return banner;
    }
}
