package ru.yandex.direct.web.entity.transparencyreport.service;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportClient;

import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_STATS_COLUMN_REVENUE_SUM_ALIAS;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.BANNERS_STATS_COLUMN_SHOWS_SUM_ALIAS;
import static ru.yandex.direct.web.entity.transparencyreport.model.TransparencyReportDbInfo.CLIENTS_COLUMN_CLIENT_NAME;

public class TransparencyReportClientsRowMapper implements RowMapper<TransparencyReportClient> {
    @Override
    public TransparencyReportClient mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();

        TransparencyReportClient client = new TransparencyReportClient();

        for (int i = 1; i <= metaData.getColumnCount(); i++) {
            switch (metaData.getColumnName(i)) {
                case CLIENTS_COLUMN_CLIENT_NAME:
                    client.withClientName(rs.getString(metaData.getColumnName(i)));
                    break;
                case BANNERS_STATS_COLUMN_REVENUE_SUM_ALIAS:
                    client.withRevenue(rs.getDouble(metaData.getColumnName(i)));
                    break;
                case BANNERS_STATS_COLUMN_SHOWS_SUM_ALIAS:
                    client.withShows(rs.getLong(metaData.getColumnName(i)));
                    break;
                default:
                    break;
            }
        }

        return client;
    }
}
