package ru.yandex.direct.web.entity.uac.controller

import io.swagger.annotations.Api
import io.swagger.annotations.ApiOperation
import org.springframework.http.HttpStatus
import org.springframework.http.MediaType.APPLICATION_JSON_VALUE
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RequestParam
import org.springframework.web.bind.annotation.ResponseBody
import org.springframework.web.bind.annotation.RestController
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource
import ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN
import ru.yandex.direct.web.entity.uac.model.UacGoalInfoResponse
import ru.yandex.direct.web.entity.uac.service.UacGoalsService
import ru.yandex.direct.web.entity.uac.toResponse

@RestController
@Api(tags = ["uac"])
@RequestMapping("/uac", produces = [APPLICATION_JSON_VALUE])
class UacGoalController(
    private val authenticationSource: DirectWebAuthenticationSource,
    private val uacGoalsService: UacGoalsService
) {
    @ApiOperation(value = "goals", httpMethod = "GET", nickname = "goals")
    @GetMapping(path = ["goals"])
    @ResponseBody
    @PreAuthorizeRead
    fun getGoals(
        @RequestParam(value = "counter_ids") counterIds: List<Long>,
        @RequestParam(value = PARAMETER_ULOGIN, required = false) ulogin: String?
    ): ResponseEntity<UacGoalInfoResponse> {
        val operator = authenticationSource.authentication.operator
        val subjectUser = authenticationSource.authentication.subjectUser
        val goals = uacGoalsService.getGoals(operator.uid, subjectUser.clientId, counterIds)
        return ResponseEntity(goals.toResponse(), HttpStatus.OK)
    }
}
