package ru.yandex.direct.web.entity.uac.controller

import io.swagger.annotations.Api
import io.swagger.annotations.ApiOperation
import org.springframework.http.HttpStatus
import org.springframework.http.MediaType
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RestController
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead
import ru.yandex.direct.web.entity.uac.model.UacProperties
import ru.yandex.direct.web.entity.uac.service.UacPropertiesService
import ru.yandex.direct.web.entity.uac.toResponse
import java.time.Duration

@RestController
@Api(tags = ["uac"])
@RequestMapping("/uac", produces = [MediaType.APPLICATION_JSON_VALUE])
class UacPropertiesController(
    private val uacPropertiesService: UacPropertiesService,
) {
    @ApiOperation(
        value = "uacPropertiesGet",
        httpMethod = "GET",
        nickname = "uacPropertiesGet",
    )
    @PreAuthorizeRead
    @GetMapping(value = ["properties"])
    open fun getUacProperties(): ResponseEntity<Any> {
        return ResponseEntity(UacProperties(
            maxTexts = uacPropertiesService.maxTexts,
            maxTitles = uacPropertiesService.maxTitles,
        ).toResponse(), HttpStatus.OK)
    }
}
