package ru.yandex.direct.web.entity.uac.controller

import io.swagger.annotations.Api
import io.swagger.annotations.ApiOperation
import io.swagger.annotations.ApiParam
import org.springframework.http.MediaType
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RequestParam
import org.springframework.web.bind.annotation.RestController
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead
import ru.yandex.direct.geobasehelper.GeoBaseHelper
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource
import ru.yandex.direct.web.entity.uac.regionIdsEmptyResponse

@RestController
@Api(tags = ["uac"])
@RequestMapping("/uac", produces = [MediaType.APPLICATION_JSON_VALUE])
class UacRegionNameController (
    private val authenticationSource: DirectWebAuthenticationSource,
    private val geoBaseHelper: GeoBaseHelper,
) {

    @ApiOperation(
        value = "regionNames",
        httpMethod = "GET",
        nickname = "regionNames"
    )
    @PreAuthorizeRead
    @GetMapping(value = ["region_names"])
    fun getRegionNames(
        @ApiParam(value = "region", required = true) @RequestParam(value = "region") regionIds: List<Long>?
    ): ResponseEntity<Any> {
        if (regionIds.isNullOrEmpty()) {
            return regionIdsEmptyResponse()
        }
        val lang = authenticationSource.authentication.subjectUser.lang.toString()
        val regions = regionIds.associateWith { geoBaseHelper.getRegionName(it, lang) }
        return ResponseEntity.ok(regions)
    }
}
