package ru.yandex.direct.web.entity.uac.converter

import ru.yandex.direct.web.entity.uac.model.DirectImageInfo

import ru.yandex.direct.core.entity.banner.model.ImageType

object DirectMdsMetaFilter {
    private val SIZES_BY_DIRECT_IMAGE_TYPE: Map<ImageType, List<String>> = mapOf(
        ImageType.SMALL to listOf("x90", "y90", "x80", "y80", "y65", "y110", "y129", "x150", "y150"),
        ImageType.REGULAR to listOf(
            "x90", "y90", "x80", "y80", "y65", "y110", "y129", "y150", "x150", "y180", "y160", "x180",
            "x160", "y300", "x300", "x320", "y320", "x378", "x360", "y360", "x410", "x450", "y450",
            "x600", "y600", "y680", "x756", "x820", "x900", "y900", "x1200"
        ),
        ImageType.WIDE to listOf("wx1080", "wy300", "wy150", "wx150", "wx600", "wx300"),
        ImageType.IMAGE_AD to listOf("orig"),
        ImageType.LOGO to listOf("orig", "x80")
    )

    fun toDirectMdsMeta(directImageInfo: DirectImageInfo): Map<String, Any> {
        return directImageInfo.mdsMeta.sizes.filterKeys {
            SIZES_BY_DIRECT_IMAGE_TYPE[directImageInfo.imageType]?.contains(it) ?: false
        }
    }
}
