package ru.yandex.direct.web.entity.uac.converter

import ru.yandex.direct.appmetrika.model.response.BundleId
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.Store
import ru.yandex.direct.web.entity.uac.model.UacAppMetrikaApp

object UacAppMetrikaAppsConverter {
    private fun toPlatform(platform: String?): Platform {
        return when (platform) {
            "android" -> Platform.ANDROID
            "ios" -> Platform.IOS
            else -> throw IllegalStateException("Illegal platform $platform")
        }
    }

    private fun toStore(platform: String?): Store {
        return when (platform) {
            "android" -> Store.GOOGLE_PLAY
            "ios" -> Store.ITUNES
            else -> throw IllegalStateException("Illegal platform $platform")
        }
    }

    fun toUacAppMetrikaApp(bundleId: BundleId): UacAppMetrikaApp {
        return UacAppMetrikaApp(
            bundleId.bundleId,
            toPlatform(bundleId.platform),
            toStore(bundleId.platform)
        )
    }
}
