package ru.yandex.direct.web.entity.uac.converter

import ru.yandex.direct.web.core.entity.mobilecontent.model.WebMobileApp
import ru.yandex.direct.web.entity.uac.model.UacDirectApp

object UacDirectAppsResponseConverter {
    fun toUacDirectApp(webMobileApp: WebMobileApp): UacDirectApp {
        return UacDirectApp(
            id = webMobileApp.id.toString(),
            hasVerification = webMobileApp.hasVerification,
            busySlots = webMobileApp.busySkadNetworkSlotsCount,
            slotsCount = webMobileApp.skadNetworkSlotsCount,
        )
    }

    fun toUacDirectApp(id: Long): UacDirectApp {
        return UacDirectApp(
            id = id.toString(),
            hasVerification = null,
            busySlots = null,
            slotsCount = null,
        )
    }
}
