package ru.yandex.direct.web.entity.uac.converter

import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.Store
import ru.yandex.direct.web.core.entity.mobilecontent.model.WebMobileApp
import ru.yandex.direct.web.core.entity.mobilecontent.model.WebOsType
import ru.yandex.direct.web.entity.uac.model.UacLibraryApp
import ru.yandex.direct.web.entity.uac.model.UacUniqAppByBundleId
import ru.yandex.direct.web.core.entity.mobilecontent.model.Store as ContentStore

object UacLibraryAppConverter {
    private fun toPlatform(platform: String?): Platform {
        return when (platform) {
            WebOsType.ANDROID.representation -> Platform.ANDROID
            WebOsType.IOS.representation -> Platform.IOS
            else -> throw IllegalStateException("Illegal platform $platform")
        }
    }

    private fun toStore(platform: String?): Store {
        return when (platform) {
            ContentStore.GOOGLE_PLAY.toString() -> Store.GOOGLE_PLAY
            ContentStore.APP_STORE.toString() -> Store.ITUNES
            else -> throw IllegalStateException("Illegal platform $platform")
        }
    }

    private fun toBundleId(content: WebMobileApp): String {
        return content.mobileContent.bundleId.orEmpty().ifEmpty { content.mobileContent.storeContentId }
    }

    fun toUacLibraryApp(content: WebMobileApp): UacLibraryApp {
        return UacLibraryApp(
            toBundleId(content),
            toPlatform(content.mobileContent.osType.representation),
            toStore(content.store.toString())
        )
    }

    fun toUniqAppByBundleId(content: WebMobileApp): UacUniqAppByBundleId {
        return UacUniqAppByBundleId(
            toBundleId(content),
            toPlatform(content.mobileContent.osType.representation),
            toStore(content.store.toString())
        )
    }
}
