package ru.yandex.direct.web.entity.uac.converter

import org.slf4j.LoggerFactory
import ru.yandex.direct.web.entity.uac.model.SaasKeyNames
import ru.yandex.direct.web.entity.uac.model.SaasResponse

object UacSaasResponseConverter {
    private val logger = LoggerFactory.getLogger(UacSaasResponseConverter::class.java)

    fun responseToDatabaseIds(saasResponse: SaasResponse): List<String> {
        return saasResponse
            .grouping?.firstOrNull()
            ?.group
            ?.mapNotNull { group ->
                group
                    .document
                    ?.map {
                        it.archiveInfo.gtaRelatedAttribute
                    }
                    ?.flatten()
                    ?.filter { attr -> attr.key == SaasKeyNames.DATABASE_ID }
                    ?.map { attr -> attr.value }
            }
            ?.flatten()
            .orEmpty()
    }

    fun responseToMaxRelevance(saasResponse: SaasResponse): Int {
        return saasResponse
            .grouping?.firstOrNull()
            ?.group
            ?.mapNotNull { group ->
                group.document
                ?.map {
                    it.relevance
                }
            }
            ?.flatten()
            ?.maxOrNull() ?: 0
    }
}
