package ru.yandex.direct.web.entity.uac.converter

import org.slf4j.LoggerFactory
import ru.yandex.direct.core.entity.domain.DomainUtils
import ru.yandex.direct.core.entity.metrikacounter.model.MetrikaCounterWithAdditionalInformation
import ru.yandex.direct.grid.processing.util.FaviconUtils
import ru.yandex.direct.organizations.swagger.OrganizationApiInfo
import ru.yandex.direct.validation.constraint.StringConstraints
import ru.yandex.direct.web.entity.uac.model.UacSiteSuggest


object UacSiteSuggestConverter {
    private val logger = LoggerFactory.getLogger(UacSiteSuggestConverter::class.java)

    fun metrikaCounterToSiteSuggest(counter: MetrikaCounterWithAdditionalInformation): UacSiteSuggest {
        return UacSiteSuggest(
            url = "https://" + counter.domain,
            title = counter.name,
            icon =  FaviconUtils.getFaviconLink(counter.domain),
        )
    }

    private fun chooseOrganizationUrl(organization: OrganizationApiInfo): String? {
        val validUrls = organization
            .urls
            .filter { t -> t.isNotBlank() && StringConstraints.isValidHref(t) }
        if (validUrls.isEmpty()) {
            logger.warn("organization without url somehow got into suggest")
            return null
        }
        return validUrls.stream()
            .filter { t: String? -> !DomainUtils.isSocialNetworkSite(t) }
            .findFirst()
            .orElse(validUrls[0])
    }

    fun organizationToSiteSuggest(organization: OrganizationApiInfo): UacSiteSuggest? {
        val url = chooseOrganizationUrl(organization) ?: return null
        return UacSiteSuggest(
            url = url,
            title = organization.companyName,
            icon =  organization.previewHref,
        )
    }
}
