package ru.yandex.direct.web.entity.uac.converter

import ru.yandex.direct.core.entity.uac.model.HolidaySettings
import ru.yandex.direct.core.entity.uac.model.TimeTarget
import ru.yandex.direct.grid.model.campaign.timetarget.GdHolidaysSettings
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget

object UacTimeTargetConverter {

    fun TimeTarget.toGdTimeTarget(): GdTimeTarget {
        return GdTimeTarget()
            .withIdTimeZone(idTimeZone)
            .withTimeBoard(timeBoard)
            .withEnabledHolidaysMode(enabledHolidaysMode)
            .withHolidaysSettings(holidaysSettings?.toGdHolidaySettings())
            .withUseWorkingWeekends(useWorkingWeekends)
    }

    private fun HolidaySettings.toGdHolidaySettings(): GdHolidaysSettings {
        return GdHolidaysSettings()
            .withStartHour(startHour)
            .withEndHour(endHour)
            .withIsShow(show)
            .withRateCorrections(rateCorrections)
    }
}
