package ru.yandex.direct.web.entity.uac.converter

import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.model.BaseUacTrackingInfo
import ru.yandex.direct.core.entity.uac.service.trackingurl.ParserType
import ru.yandex.direct.core.entity.uac.service.trackingurl.TrackingUrlParseService
import ru.yandex.direct.web.entity.uac.model.LastCampaignInfo
import ru.yandex.direct.web.entity.uac.model.UacTrackingInfo

@Lazy
@Service
class UacTrackingInfoConverter(
    private val trackingUrlParseService: TrackingUrlParseService
) {
    fun toUacTrackingInfo(trackingInfos: List<BaseUacTrackingInfo>): List<UacTrackingInfo> {
        return trackingInfos
            .map { UacTrackingInfo(
                trackingUrl = it.trackingUrl,
                impressionUrl = it.impressionUrl,
                trackerName = trackingUrlParseService.parse(
                    it.trackingUrl ?: "", null, ParserType.TRACKING_URL)?.system,
                lastCampaignInfo = LastCampaignInfo(
                    id = it.id,
                    name = it.name,
                    createdTime = it.createdTime
                )
            ) }
    }
}
