package ru.yandex.direct.web.entity.uac.converter.proto

import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration
import ru.yandex.direct.utils.JsonUtils
import ru.yandex.direct.web.entity.uac.model.UacCampaignProtoResponse
import ru.yandex.direct.web.entity.uac.model.UacCampaignResponse

fun getDirectCampaignProtoResponseDiffer(
    percentGetter: () -> Int,
): ProtoResponseDiffer<UacCampaignProtoResponse, UacCampaignResponse> {
    return ProtoResponseDiffer(
        UacGetCampaignProtoResponseMapper(JsonUtils.MAPPER),
        "getDirectCampaign",
        percentGetter,
        RecursiveComparisonConfiguration.builder()
            .withIgnoredFields(
                "result.appInfo.iconUrl",
            )
            .withIgnoredCollectionOrderInFields(
                "result.accessKt.actions",
                "result.accessKt.pseudoActions",
                "result.appInfo.interests",
                "result.altAppStores",
                "result.deviceTypes",
                "result.inventoryTypes",
            )
            .build(),
    ) {
        val contents = it.result!!.contents.map { content ->
            content.copy(meta = normalizeMeta(content.meta))
        }
        val campaign = it.result!!.copy(contents = contents)
        it.copy().withResult(campaign)
    }
}

private fun normalizeMeta(meta: Map<String, Any?>): Map<String, Any?> {
    return meta.mapValues {
        when (it.value) {
            is Map<*, *> -> normalizeMeta(it.value as Map<String, Any?>)
            else -> it.value
        }
    }.filterValues {
        when (it) {
            is Collection<*> -> it.isNotEmpty()
            null -> false
            else -> true
        }
    }
}
