package ru.yandex.direct.web.entity.uac.converter.proto

import ru.yandex.direct.core.entity.campaign.model.BrandSurveyStatus
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeo
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSegment
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSegmentDetails
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toEAgePoint
import ru.yandex.direct.core.entity.uac.model.AppInfo
import ru.yandex.direct.core.entity.uac.model.UacAdjustment
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.moneyToDb
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdLong
import ru.yandex.direct.web.entity.uac.converter.proto.enummappers.UacEnumMappers.Companion.toProtoBrandSurveyStatus
import ru.yandex.direct.web.entity.uac.converter.proto.enummappers.UacEnumMappers.Companion.toProtoBrandSurveyStopReason
import ru.yandex.direct.web.entity.uac.converter.proto.enummappers.UacEnumMappers.Companion.toProtoCampaignAction
import ru.yandex.direct.web.entity.uac.converter.proto.enummappers.UacEnumMappers.Companion.toProtoCampaignServicedState
import ru.yandex.direct.web.entity.uac.converter.proto.enummappers.UacEnumMappers.Companion.toProtoGender
import ru.yandex.direct.web.entity.uac.converter.proto.enummappers.UacEnumMappers.Companion.toProtoGeoSegment
import ru.yandex.direct.web.entity.uac.converter.proto.enummappers.UacEnumMappers.Companion.toProtoPlatform
import ru.yandex.direct.web.entity.uac.model.UacCampaignAccess
import ru.yandex.direct.web.entity.uac.model.UacCampaignAgencyInfo
import ru.yandex.direct.web.entity.uac.model.UacCampaignManagerInfo
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TAdjustment
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TAppInfo
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TBrandSurveyStatus
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TCampaignAccess
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TCampaignAgencyInfo
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TCampaignManagerInfo
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TContactPhone
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.THyperGeo
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.THyperGeo.THyperGeoSegment
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.THyperGeo.THyperGeoSegmentDetails

object UacCampaignProtoConverter {

    fun toProto(value: UacCampaignAccess): TCampaignAccess {
        return TCampaignAccess.newBuilder().apply {
            canEdit = value.canEdit
            noActions = value.noActions
            addAllActions(value.actions.map { toProtoCampaignAction(it) })
            addAllPseudoActions(value.pseudoActions.map { toProtoCampaignAction(it) })
            servicedState = toProtoCampaignServicedState(value.servicedState)
        }.build()
    }

    fun toProto(value: UacCampaignAgencyInfo): TCampaignAgencyInfo {
        return TCampaignAgencyInfo.newBuilder().apply {
            if (value.name != null) {
                name = value.name
            }
            if (value.email != null) {
                email = value.email
            }
            if (value.phone != null) {
                phone = value.phone
            }
            if (value.representativeName != null) {
                representativeName = value.representativeName
            }
            showAgencyContacts = value.showAgencyContacts
        }.build()
    }

    fun toProto(value: UacCampaignManagerInfo): TCampaignManagerInfo {
        return TCampaignManagerInfo.newBuilder().apply {
            if (value.name != null) {
                name = value.name
            }
            if (value.email != null) {
                email = value.email
            }
            if (value.contactInfo != null) {
                addAllContactInfo(value.contactInfo.map {
                    TContactPhone.newBuilder().apply {
                        if (it.phone != null) {
                            phone = it.phone
                        }
                        if (it.extension != null) {
                            extension = it.extension
                        }
                    }.build()
                })
            }
        }.build()
    }

    fun toProto(value: HyperGeo): THyperGeo {
        return THyperGeo.newBuilder().apply {
            if (value.id != null) {
                id = value.id
            }
            if (value.name != null) {
                name = value.name
            }
            val segments = value.hyperGeoSegments
            if (segments != null) {
                addAllHyperGeoSegments(segments.map { toProto(it) })
            }
        }.build()
    }

    fun toProto(value: HyperGeoSegment): THyperGeoSegment {
        return THyperGeoSegment.newBuilder().apply {
            if (value.id != null) {
                goalId = value.id
            }
            if (value.clientId != null) {
                clientId = value.clientId
            }
            if (value.coveringGeo != null) {
                addAllCoveringGeo(value.coveringGeo)
            }
            if (value.segmentDetails != null) {
                hyperGeoSegmentDetails = toProto(value.segmentDetails)
            }
        }.build()
    }

    fun toProto(value: HyperGeoSegmentDetails): THyperGeoSegmentDetails {
        return THyperGeoSegmentDetails.newBuilder().apply {
            if (value.segmentName != null) {
                segmentName = value.segmentName
            }
            if (value.radius != null) {
                radius = value.radius
            }
            if (value.points != null) {
                addAllPoints(value.points.map {
                    THyperGeo.THyperPoint.newBuilder().apply {
                        if (it.latitude != null) {
                            latitude = it.latitude
                        }
                        if (it.longitude != null) {
                            longitude = it.longitude
                        }
                        if (it.address != null) {
                            address = it.address
                        }
                    }.build()
                })
            }
            if (value.periodLength != null) {
                periodLength = value.periodLength
            }
            if (value.timesQuantity != null) {
                timesQuantity = value.timesQuantity
            }
            if (value.geoSegmentType != null) {
                geoSegmentType = toProtoGeoSegment(value.geoSegmentType)
            }
        }.build()
    }

    fun toProto(value: BrandSurveyStatus): TBrandSurveyStatus {
        return TBrandSurveyStatus.newBuilder().apply {
            if (value.surveyStatusDaily != null) {
                surveyStatusDaily = toProtoBrandSurveyStatus(value.surveyStatusDaily)
            }
            if (value.reasonIds != null) {
                addAllReasonIds(value.reasonIds)
            }
            if (value.brandSurveyStopReasonsDaily != null) {
                addAllBrandSurveyStopReasonsDaily(value.brandSurveyStopReasonsDaily.map {
                    toProtoBrandSurveyStopReason(it)
                })
            }
            if (value.sumSpentByDay != null) {
                sumSpentByDay = moneyToDb(value.sumSpentByDay)
            }
            if (value.sumSpentByTotalPeriod != null) {
                sumSpentByTotalPeriod = moneyToDb(value.sumSpentByTotalPeriod)
            }
        }.build()
    }

    fun toProto(value: AppInfo): TAppInfo {
        return TAppInfo.newBuilder().apply {
            appInfoBuilder.apply {
                if (value.id != null) {
                    metaBuilder.apply {
                        id = value.id!!.toIdLong()
                    }
                }
                specBuilder.apply {
                    appId = value.appId
                    if (value.bundleId != null) {
                        bundleId = value.bundleId
                    }
                    if (value.language != null) {
                        language = value.language
                    }
                    if (value.region != null) {
                        region = value.region
                    }
                    platform = toProtoPlatform(value.platform).number
                }

            }
            if (value.title != null) {
                title = value.title
            }
            if (value.subtitle != null) {
                subtitle = value.subtitle
            }
            if (value.description != null) {
                description = value.description
            }
            if (value.iconUrl != null) {
                iconUrl = value.iconUrl
            }
            url = value.url
            if (value.vendor != null) {
                vendor = value.vendor
            }
            if (value.rating != null) {
                rating = value.rating!!
            }
            if (value.reviews != null) {
                reviews = value.reviews!!
            }
            if (value.ageLimit != null) {
                ageLimit = value.ageLimit!!
            }
            if (value.minOsVersion != null) {
                minOsVersion = value.minOsVersion
            }
            if (value.currency != null) {
                currency = value.currency
            }
            if (value.price != null) {
                price = value.price!!
            }
            if (value.interests != null) {
                addAllInterests(value.interests)
            }
            if (value.recommendedCpa != null) {
                recommendedCpa = value.recommendedCpa!!
            }
            if (value.recommendedCpi != null) {
                recommendedCpi = value.recommendedCpi!!
            }
        }.build()
    }

    fun toProto(value: UacAdjustment): TAdjustment {
        return TAdjustment.newBuilder().apply {
            adjustmentBuilder.apply {
                if (value.region != null) {
                    region = value.region!!
                }
                if (value.gender != null) {
                    gender = toProtoGender(value.gender!!)
                }
                if (value.age != null) {
                    age = value.age!!.toEAgePoint()
                }
                percent = value.percent
                if (value.retargetingConditionId != null) {
                    retargetingConditionId = value.retargetingConditionId!!
                }
            }
            if (value.regionName != null) {
                regionName = value.regionName
            }
        }.build()
    }
}
