package ru.yandex.direct.web.entity.uac.converter.proto

import ru.yandex.direct.core.entity.uac.UacCommonUtils
import ru.yandex.direct.core.entity.uac.model.Content
import ru.yandex.direct.core.entity.uac.model.MediaType
import ru.yandex.direct.core.entity.uac.model.Sitelink
import ru.yandex.direct.core.entity.uac.service.BaseUacContentService
import ru.yandex.direct.core.grut.api.utils.colorStringToUint64
import ru.yandex.direct.web.entity.uac.converter.proto.enummappers.UacEnumMappers
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TContent
import ru.yandex.direct.web.proto.api.uac.GetCampaignResponse.TContent.TImageContentMeta.TDirectMdsMetaElement
import ru.yandex.grut.objects.proto.Asset
import ru.yandex.grut.objects.proto.MdsInfo
import ru.yandex.grut.objects.proto.MdsInfo.TAvatarsImageMeta.TFormat.TSmartCenter

object UacContentProtoConverter {

    fun toProto(value: Sitelink): Asset.TSitelinkAsset {
        return Asset.TSitelinkAsset.newBuilder().apply {
            title = value.title
            href = value.href
            if (value.description != null) {
                description = value.description
            }
        }.build()
    }

    private fun toSmartCenterProto(raw: Map<String, Any?>) = TSmartCenter.newBuilder().apply {
        h = raw["h"] as? Int ?: 0
        w = raw["w"] as? Int ?: 0
        x = raw["x"] as? Int ?: 0
        y = raw["y"] as? Int ?: 0
    }.build()

    // See direct/core/entity/uac/service/BaseUacContentService.kt
    @Suppress("UNCHECKED_CAST")
    fun toProto(rawMeta: Map<String, Any?>, mediaType: MediaType): TContent.TMeta {
        return TContent.TMeta.newBuilder().apply {
            when (mediaType) {
                MediaType.IMAGE -> {
                    imageBuilder.apply {
                        avatarsImageMetaBuilder.apply {
                            val colorWiz = rawMeta["ColorWiz"] as? Map<String, Any?>
                            if (colorWiz != null) {
                                val colorWizBack = colorWiz["ColorWizBack"] as? String
                                val colorWizButton = colorWiz["ColorWizButton"] as? String
                                val colorWizButtonText = colorWiz["ColorWizButtonText"] as? String
                                val colorWizText = colorWiz["ColorWizText"] as? String

                                if (colorWizBack != null) {
                                    this.colorWizBackground = colorStringToUint64(colorWizBack)
                                }
                                if (colorWizButton != null) {
                                    this.colorWizButton = colorStringToUint64(colorWizButton)
                                }
                                if (colorWizButtonText != null) {
                                    this.colorWizButtonText = colorStringToUint64(colorWizButtonText)
                                }
                                if (colorWizText != null) {
                                    this.colorWizText = colorStringToUint64(colorWizText)
                                }
                            }

                            for (size in BaseUacContentService.SIZES) {
                                val sizeData = rawMeta[size] as? Map<String, Any?>
                                if (sizeData != null) {
                                    val width = sizeData["width"] as? Number ?: 0
                                    val height = sizeData["height"] as? Number ?: 0
                                    val smartCenter = sizeData["smart-center"] as? Map<String, Any?>
                                    val smartCenters = sizeData["smart-centers"] as? Iterable<Map<String, Any?>>

                                    val format = MdsInfo.TAvatarsImageMeta.TFormat.newBuilder().apply {
                                        this.formatName = size
                                        this.width = width.toInt()
                                        this.height = height.toInt()
                                        if (smartCenter != null) {
                                            this.smartCenter = toSmartCenterProto(smartCenter)
                                        }
                                        if (smartCenters != null) {
                                            addAllSmartCenters(smartCenters.map { toSmartCenterProto(it) })
                                        }
                                    }.build()
                                    addFormats(format)
                                }
                            }
                        }

                        val directImageHash = rawMeta["direct_image_hash"] as? String
                        if (directImageHash != null) {
                            this.directImageHash = directImageHash
                        }

                        val directMdsMeta = rawMeta["direct_mds_meta"] as? Map<String, Any?>
                        if (directMdsMeta != null) {
                            for ((sizeName, value) in directMdsMeta) {
                                val sizeDescription = value as Map<String, Any?>
                                val height = sizeDescription["height"] as? Number
                                val width = sizeDescription["width"] as? Number
                                val path = sizeDescription["path"] as? String
                                val smartCenters = sizeDescription["smart-centers"] as? Map<String, Any?>

                                val mdsMetaElement = TDirectMdsMetaElement.newBuilder().apply {
                                    if (path != null) {
                                        this.path = path
                                    }
                                    if (width != null) {
                                        sizeBuilder.width = width.toInt()
                                    }
                                    if (height != null) {
                                        sizeBuilder.height = height.toInt()
                                    }
                                    if (smartCenters != null) {
                                        for ((format, smartCenterValue) in smartCenters) {
                                            val smartCenter = smartCenterValue as? Map<String, Int>
                                            if (smartCenter != null) {
                                                putSmartCenters(format, toSmartCenterProto(smartCenter))
                                            }
                                        }
                                    }
                                }.build()
                                putDirectMdsMeta(sizeName, mdsMetaElement)
                            }
                        }
                    }
                }
                MediaType.VIDEO -> {
                    videoBuilder.apply {
                        val formats = rawMeta["formats"] as? Iterable<Map<String, Any?>>
                        val status = rawMeta["status"] as? String
                        val thumb = rawMeta["thumb"] as? Map<String, Any?>
                        val creativeId = rawMeta[UacCommonUtils.CREATIVE_ID_KEY] as? Number
                        val creativeType = rawMeta[UacCommonUtils.CREATIVE_TYPE_KEY] as? String
                        val vast = rawMeta["vast"] as? String

                        if (formats != null) {
                            addAllFormats(formats.map { format ->
                                val type = format["type"]
                                val url = format["url"]
                                val delivery = format["delivery"]
                                val bitrate = format["bitrate"]

                                TContent.TVideoContentMeta.TFormat.newBuilder().apply {
                                    if (type is String) {
                                        this.type = type
                                    }
                                    if (url is String) {
                                        this.url = url
                                    }
                                    if (delivery is String) {
                                        this.delivery = delivery
                                    }
                                    if (bitrate is Number) {
                                        this.bitrate = bitrate.toInt()
                                    }
                                }.build()
                            })
                        }

                        if (status is String) {
                            this.status = status
                        }
                        if (thumb != null) {
                            val url = thumb["url"] as? String
                            val width = thumb["width"] as? Number
                            val height = thumb["height"] as? Number
                            val preview = thumb["preview"] as? Map<String, Any?>

                            thumbBuilder.apply {
                                if (url != null) {
                                    this.url = url
                                }
                                if (width != null) {
                                    this.width = width.toInt()
                                }
                                if (height != null) {
                                    this.height = height.toInt()
                                }
                                if (preview != null) {
                                    val previewUrl = preview["url"] as? String
                                    val previewWidth = preview["width"] as? Number
                                    val previewHeight = preview["height"] as? Number

                                    previewBuilder.apply {
                                        if (previewUrl != null) {
                                            this.url = previewUrl
                                        }
                                        if (previewWidth != null) {
                                            this.width = previewWidth.toInt()
                                        }
                                        if (previewHeight != null) {
                                            this.height = previewHeight.toInt()
                                        }
                                    }
                                }
                            }

                        }
                        if (creativeId != null) {
                            this.creativeId = creativeId.toLong()
                        }
                        if (creativeType != null) {
                            this.creativeType = creativeType
                        }
                        if (vast != null) {
                            this.vast = vast
                        }
                    }
                }
                MediaType.HTML5 -> {
                    html5Builder.apply {
                        val previewUrl = rawMeta["preview_url"] as? String
                        val screenshotUrl = rawMeta["screenshot_url"] as? String
                        val creativeId = rawMeta[UacCommonUtils.CREATIVE_ID_KEY] as? Number
                        val creativeType = rawMeta[UacCommonUtils.CREATIVE_TYPE_KEY] as? String
                        val url = rawMeta["url"] as? String

                        if (previewUrl != null) {
                            this.previewUrl = previewUrl
                        }
                        if (screenshotUrl != null) {
                            this.screenshotUrl = screenshotUrl
                        }
                        if (creativeId != null) {
                            this.creativeId = creativeId.toLong()
                        }
                        if (creativeType != null) {
                            this.creativeType = creativeType
                        }
                        if (url != null) {
                            this.url = url
                        }
                    }
                }
                else -> {}
            }
        }.build()
    }

    fun toProto(value: Content): TContent {
        return TContent.newBuilder().apply {
            id = value.id
            mediaType = UacEnumMappers.toProtoMediaType(value.type)
            thumb = value.thumb
            thumbId = value.thumbId
            sourceUrl = value.sourceUrl
            if (value.directImageHash != null) {
                directImageHash = value.directImageHash
            }
            origSizeBuilder.apply {
                width = value.iw
                height = value.ih
            }
            if (value.tw != null && value.th != null) {
                contentSizeBuilder.apply {
                    width = value.tw!!
                    height = value.th!!
                }
            }
            if (value.ow != null && value.oh != null) {
                origCreativeSizeBuilder.apply {
                    width = value.ow!!
                    height = value.oh!!
                }
            }
            if (value.mdsUrl != null) {
                mdsUrl = value.mdsUrl
            }
            if (value.videoDuration != null) {
                videoDuration = value.videoDuration!!
            }
            if (value.filename != null) {
                filename = value.filename
            }
            meta = toProto(value.meta, value.type)
        }.build()
    }
}
