package ru.yandex.direct.web.entity.uac.converter.proto.enummappers

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason
import ru.yandex.direct.core.entity.campaign.model.BrandSurveyStopReason
import ru.yandex.direct.core.entity.campaign.model.SurveyStatus
import ru.yandex.direct.core.entity.hypergeo.model.GeoSegmentType
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppAlternativeStore
import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.model.AgePoint
import ru.yandex.direct.core.entity.uac.model.Gender
import ru.yandex.direct.core.entity.uac.model.MediaType
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.Status
import ru.yandex.direct.core.entity.uac.repository.ydb.schema.CAMPAIGN
import ru.yandex.direct.mysql2grut.enummappers.buildEnumMapping
import ru.yandex.direct.mysql2grut.enummappers.convert
import ru.yandex.direct.mysql2grut.enummappers.convertWithDefaultNull
import ru.yandex.direct.web.entity.uac.model.UacCampaignAction
import ru.yandex.direct.web.entity.uac.model.UacCampaignServicedState
import ru.yandex.grut.objects.proto.AgeGroup.EAgeGroup
import ru.yandex.grut.objects.proto.AppInfo.TAppInfoSpec.EPlatform
import ru.yandex.grut.objects.proto.AppStore.EAppStore
import ru.yandex.grut.objects.proto.BrandSurvey.EBrandSurveyStatus
import ru.yandex.grut.objects.proto.BrandSurvey.EBrandSurveyStopReason
import ru.yandex.grut.objects.proto.Campaign.ECampaignAction
import ru.yandex.grut.objects.proto.Campaign.ECampaignServicedState
import ru.yandex.grut.objects.proto.Campaign.ECampaignTypeOld
import ru.yandex.grut.objects.proto.CampaignBriefStatus.ECampaignBriefStatus
import ru.yandex.grut.objects.proto.Gender.EGender
import ru.yandex.grut.objects.proto.GeoSegment.EGeoSegment
import ru.yandex.grut.objects.proto.MediaType.EMediaType
import ru.yandex.grut.objects.proto.SelfStatusReason.ESelfStatusReason

class UacEnumMappers {
    companion object {
        data class Mapper<From : Enum<From>, To : Enum<To>>(
            val to: Map<From, To>,
            val from: Map<To, From>,
        )

        private fun <From : Enum<From>, To : Enum<To>> buildTwoSideEnumMapping(
            fromClass: Class<From>,
            toClass: Class<To>,
            customMapping: Map<From, To> = emptyMap(),
            customFromLiteralAccessor: Function1<From, String>? = null,
            customToLiteralAccessor: Function1<To, String>? = null,
        ): Mapper<From, To> {
            val forwardMapping =
                buildEnumMapping(fromClass, toClass, customMapping, customFromLiteralAccessor, customToLiteralAccessor)
            val backwardMapping = forwardMapping.map { (from, to) -> to to from }.toMap()
            return Mapper(forwardMapping, backwardMapping)
        }

        private val lowerCaseNameGetter: Function1<Enum<*>, String> = { e: Enum<*> -> e.name.lowercase() }

        val CAMPAIGN_STATUS_MAPPER = buildTwoSideEnumMapping(
            Status::class.java, ECampaignBriefStatus::class.java, customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoStatus(value: Status): ECampaignBriefStatus {
            return convert(CAMPAIGN_STATUS_MAPPER.to, ECampaignBriefStatus.CBS_UNKNOWN, value)
        }

        fun fromProtoStatus(value: ECampaignBriefStatus): Status? {
            return convertWithDefaultNull(CAMPAIGN_STATUS_MAPPER.from, value)
        }

        val STATE_REASONS_MAPPER = buildEnumMapping(
            GdSelfStatusReason::class.java,
            ESelfStatusReason::class.java,
            customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoSelfStatusReason(value: GdSelfStatusReason): ESelfStatusReason {
            return convert(STATE_REASONS_MAPPER, ESelfStatusReason.SSR_UNKNOWN, value)
        }

        val MOBILE_APP_ALTERNATIVE_STORE_MAPPER = buildTwoSideEnumMapping(
            MobileAppAlternativeStore::class.java, EAppStore::class.java
        )

        fun toProtoAltAppStore(value: MobileAppAlternativeStore): EAppStore {
            return convert(MOBILE_APP_ALTERNATIVE_STORE_MAPPER.to, EAppStore.AS_UNKNOWN, value)
        }

        fun fromProtoAppStore(value: EAppStore): MobileAppAlternativeStore? {
            return convertWithDefaultNull(MOBILE_APP_ALTERNATIVE_STORE_MAPPER.from, value)
        }

        val GEO_SEGMENT_TYPE_MAPPER = buildEnumMapping(
            GeoSegmentType::class.java, EGeoSegment::class.java
        )

        fun toProtoGeoSegment(value: GeoSegmentType): EGeoSegment {
            return convert(GEO_SEGMENT_TYPE_MAPPER, EGeoSegment.GS_UNKNOWN, value)
        }

        val BRAND_SURVEY_STATUS_MAPPER = buildEnumMapping(
            SurveyStatus::class.java, EBrandSurveyStatus::class.java, customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoBrandSurveyStatus(value: SurveyStatus): EBrandSurveyStatus {
            return convert(BRAND_SURVEY_STATUS_MAPPER, EBrandSurveyStatus.BSS_UNKNOWN, value)
        }

        val BRAND_SURVEY_STOP_REASON_MAPPER = buildEnumMapping(
            BrandSurveyStopReason::class.java,
            EBrandSurveyStopReason::class.java,
            customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoBrandSurveyStopReason(value: BrandSurveyStopReason): EBrandSurveyStopReason {
            return convert(BRAND_SURVEY_STOP_REASON_MAPPER, EBrandSurveyStopReason.BSSR_UNKNOWN, value)
        }

        val CAMPAIGN_ACTION_MAPPER = buildEnumMapping(
            UacCampaignAction::class.java, ECampaignAction::class.java, customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoCampaignAction(value: UacCampaignAction): ECampaignAction {
            return convert(CAMPAIGN_ACTION_MAPPER, ECampaignAction.CA_NOT_SPECIFIED, value)
        }

        val CAMPAIGN_SERVICED_STATE_MAPPER = buildEnumMapping(
            UacCampaignServicedState::class.java,
            ECampaignServicedState::class.java,
            customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoCampaignServicedState(value: UacCampaignServicedState): ECampaignServicedState {
            return convert(CAMPAIGN_SERVICED_STATE_MAPPER, ECampaignServicedState.CSS_UNKNOWN, value)
        }

        val CAMPAIGN_TYPE_MAPPER = buildEnumMapping(
            AdvType::class.java, ECampaignTypeOld::class.java,
            mapOf(AdvType.MOBILE_CONTENT to ECampaignTypeOld.CTO_MOBILE_APP),
            customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoCampaignType(value: AdvType): ECampaignTypeOld {
            return convert(CAMPAIGN_TYPE_MAPPER, ECampaignTypeOld.CTO_UNKNOWN, value)
        }

        val AGE_POINT_MAPPER = buildEnumMapping(
            AgePoint::class.java, EAgeGroup::class.java,
            mapOf(
                AgePoint.AGE_0 to EAgeGroup.AG_0_17,
                AgePoint.AGE_18 to EAgeGroup.AG_18_24,
                AgePoint.AGE_25 to EAgeGroup.AG_25_34,
                AgePoint.AGE_35 to EAgeGroup.AG_35_44,
                AgePoint.AGE_45 to EAgeGroup.AG_45_54,
                AgePoint.AGE_55 to EAgeGroup.AG_55_,
            )
        )

        fun toProtoAgeGroup(value: AgePoint): EAgeGroup {
            return convert(AGE_POINT_MAPPER, EAgeGroup.AG_UNKNOWN, value)
        }

        val GENDER_MAPPER = buildEnumMapping(
            Gender::class.java, EGender::class.java, customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoGender(value: Gender): EGender {
            return convert(GENDER_MAPPER, EGender.G_UNKNOWN, value)
        }

        val MEDIA_TYPE_MAPPER = buildEnumMapping(
            MediaType::class.java, EMediaType::class.java, customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoMediaType(value: MediaType): EMediaType {
            return convert(MEDIA_TYPE_MAPPER, EMediaType.MT_NOT_SPECIFIED, value)
        }

        val PLATFORM_MAPPER = buildEnumMapping(
            Platform::class.java, EPlatform::class.java, customFromLiteralAccessor = lowerCaseNameGetter
        )

        fun toProtoPlatform(value: Platform): EPlatform {
            return convert(PLATFORM_MAPPER, EPlatform.P_NOT_SPECIFIED, value)
        }
    }
}
