package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.uac.repository.ydb.model.TrackerAppEvent
import ru.yandex.direct.web.entity.SuccessResponse

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class AggregatedTrackingUrlStat(
    val anyUrlEvents: YesNoUndefined,
    val urlEvents: Map<TrackerAppEvent, YesNoUndefined>,
    val anyPackageEvents: YesNoUndefined,
    val allPackageEvents: YesNoUndefined,
)

enum class YesNoUndefined {
    YES,
    NO,
    UNDEFINED,
    ;

    @JsonValue
    open fun getName() = name.lowercase()
}

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class AggregatedTrackingUrlStatResponse(
    val reqId: String,
): SuccessResponse<AggregatedTrackingUrlStat>()
