package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.uac.model.TrackingUrl
import ru.yandex.direct.web.entity.SuccessResponse

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class CreatedImpressionUrl(
    val url: String,
    val externalLink: String
) {
    companion object {
        fun fromTrackingUrl(trackingUrl: TrackingUrl): CreatedImpressionUrl {
            return CreatedImpressionUrl(
                url = trackingUrl.getUrl(),
                externalLink = trackingUrl.externalLink
            )
        }
    }
}

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class CreateImpressionUrlResponse(
    val reqId: String,
): SuccessResponse<CreatedImpressionUrl>()
