package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.web.entity.uac.converter.UacContentStatisticsConverter.ratio
import ru.yandex.direct.web.entity.uac.converter.UacContentStatisticsConverter.ratioFromMicros
import ru.yandex.direct.ytwrapper.dynamic.dsl.YtMappingUtils.fromMicros

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class CreativeStatistics(
    val clicks: Long,
    val shows: Long,
    val costMicros: Long,
    val costCurMicros: Long,
    val costTaxFreeMicros: Long,
    val cost: Double = fromMicros(costMicros).toDouble(),
    val avgCpm: Double,
    val avgCpc: Double,
    val videoAvgTrueViewCost: Double,
    val uniqViewers: Long,
    val videoFirstQuartileRate: Double,
    val videoMidpointRate: Double,
    val videoThirdQuartileRate: Double,
    val videoCompleteRate: Double,
    val videoTrueView: Long,
    val avgNShow: Double,
    val avgNShowComplete: Double,
    val conversions: Long,
    val installs: Long,
    val postViewConversions: Long,
    val postViewInstalls: Long,
    val ctr: Double = ratio(100 * clicks.toDouble(), shows.toDouble()) ?: 0.0,
    val cr: Double = ratio(100 * conversions.toDouble(), clicks.toDouble()) ?: 0.0,
    val cpa: Double = ratioFromMicros(costTaxFreeMicros, conversions)?.toDouble() ?: 0.0,
    val cpc: Double = ratioFromMicros(costTaxFreeMicros, clicks)?.toDouble() ?: 0.0,
    val cpm: Double = ratioFromMicros(1000 * costTaxFreeMicros, shows)?.toDouble() ?: 0.0,
)

val EMPTY_STAT = CreativeStatistics(
    shows = 0,
    clicks = 0,
    conversions = 0,
    cost = 0.0,
    costMicros = 0,
    costCurMicros = 0,
    costTaxFreeMicros = 0,
    installs = 0,
    postViewConversions = 0,
    postViewInstalls = 0,
    avgCpm = 0.0,
    avgCpc = 0.0,
    videoAvgTrueViewCost = 0.0,
    uniqViewers = 0,
    videoFirstQuartileRate = 0.0,
    videoMidpointRate = 0.0,
    videoThirdQuartileRate = 0.0,
    videoCompleteRate = 0.0,
    videoTrueView = 0,
    avgNShow = 0.0,
    avgNShowComplete = 0.0,
)
