package ru.yandex.direct.web.entity.uac.model

import ru.yandex.direct.avatars.client.model.answer.ImageSize
import ru.yandex.direct.core.entity.uac.UacCommonUtils.mapFromJson
import ru.yandex.direct.core.entity.uac.model.UacAvatarsMeta
import ru.yandex.direct.utils.JsonUtils

class MetaFilter {
    companion object {
        private val SIZES: List<String> = listOf(
            "wx1080",
            "s16x9",
            "thumb",
            "s4x3",
            "s3x4",
            "s1080x607",
        )
    }

    fun filter(input: UacAvatarsMeta, sizes: Map<String, ImageSize>): Map<String, Any> {
        val meta = Meta()
        meta.setRequiredFields(input)
        meta.setSizes(sizes)
        return meta.meta
    }

    inner class Meta {
        val meta = mutableMapOf<String, Any>()

        fun setRequiredFields(input: UacAvatarsMeta) {
            meta["ColorWizBack"] = input.colorWizBack
            meta["ColorWizButton"] = input.colorWizButton
            meta["ColorWizButtonText"] = input.colorWizButtonText
            meta["ColorWizText"] = input.colorWizText
            meta["crc64"] = input.crc64
            meta["orig-size"] = mapOf(
                "width" to input.trueOrigSize.width,
                "height" to input.trueOrigSize.height,
            )
            meta["orig-format"] = "image/" + input.origFormat.lowercase()
            meta["orig-animated"] = input.origAnimated
            meta["orig-size-bytes"] = input.origSizeBytes
        }

        fun setSizes(sizes: Map<String, ImageSize>) {
            meta["sizes"] = SIZES.map {
                it to sizes[it]
            }.toMap().filterValues {
                it != null
            }.mapValues {toMetaSize(it.component2()!!)}
        }

        private fun toMetaSize(imageSize: ImageSize): Map<String, Any> {
            val result = mutableMapOf<String, Any>(
                "height" to imageSize.height,
                "width" to imageSize.width
            )
            if (imageSize.smartCenter != null) {
                result["smart-center"] = mapFromJson(JsonUtils.toJson(imageSize.smartCenter))
            }
            if (imageSize.smartCenters != null) {
                result["smart-centers"] = mapFromJson(JsonUtils.toJson(imageSize.smartCenters))
            }
            return result
        }
    }
}
